---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, index, construire un index,
              ajouter un index, personnaliser un index
---

# Comment changer le style de certains mots indexés ?

Le symbole `@` dans la commande `\index` permet d'indiquer de répondre 
à ce besoin. Voici un exemple :

```{noedit}
\index{Sport@\textbf{Sport}}
```

Dans ce cas, la partie qui se trouve avant le `@` sert pour le tri de l'index
et ce qui se trouve après correspond à ce qui sera affiché dans l'index. 
Ainsi, dans notre exemple, le mot "Sport" écrit en gras sera mis dans l'index
à l'endroit où doit se trouver le terme `Sport`. Ce mécanisme s'avère 
très utile notamment pour les mots commençant par une lettre accentuée, 
puisque pour `makeindex`, "équitation" ne commence pas par un `e` 
mais par un *symbole*.

L'exemple suivant montre comment combiner cela avec la hiérarchisation 
de l'index illustrée à la question 
"[](/3_composition/annexes/index/construire_un_index_hierarchique)".

```
%!TEX makeindex document
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{makeidx}

  \makeindex

\begin{document}
\section{Sports}
Le sport\index{Sport@\textbf{Sport}} c'est fantastique ! Mes sports préférés 
sont :
\begin{itemize}
  \item l'escalade 
    \index{Sport@\textbf{Sport}!%
      Escalade@\textsf{Escalade}} 
    et surtout les sorties en falaise ;
  \item l'équitation 
    \index{Sport@\textbf{Sport}!%
      Equitation@\textsf{Équitation}} 
    et en particulier les disciplines de dressage\index{Sport@\textbf{Sport}!%
      Equitation@\textsf{Équitation}!%
      Dressage@\textsf{Dressage}}
    et de complet \index{Sport@\textbf{Sport}!%
      Equitation@\textsf{Équitation}!%
      Complet@\textsf{Complet}} ;
  \item le judo\index{Sport@\textbf{Sport}!%
    Judo@\textsf{Judo}}.
\end{itemize}
\printindex
\end{document}
```

Notez que, dans l'exemple, nous sommes systématiquement revenus à la ligne 
après le symbole `!` pour éviter des lignes trop longues. Si vous faites
cela, pensez à le faire partout sinon vous pourriez avoir des doublons 
de référence dans l'index.


:::{sources}
- [Documentation] de <ctanpkg:makeidx>
:::