#region License, Terms and Conditions
//
// Jayrock - JSON and JSON-RPC for Microsoft .NET Framework and Mono
// Written by Atif Aziz (www.raboof.com)
// Copyright (c) 2005 Atif Aziz. All rights reserved.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
//
#endregion

namespace Jayrock.Services
{
    #region Imports

    using System;
    using System.Runtime.Serialization;

    #endregion

    /// <summary>
    /// The exception that is thrown when <see cref="IMethodImpl.Invoke"/> 
    /// or its asynchronous version fails.
    /// </summary>

    [ Serializable ]
    public class TargetMethodException : Exception
    {
        private const string _defaultMessage = "Exception has been thrown by the target of the JSON-RPC invocation.";

        public TargetMethodException(Exception innerException) :
            base(_defaultMessage, innerException) {}

        public TargetMethodException(string message) : 
            base(Mask.NullString(message, _defaultMessage)) {}

        public TargetMethodException(string message, Exception innerException) :
            base(Mask.NullString(message, _defaultMessage), innerException) {}

        protected TargetMethodException(SerializationInfo info, StreamingContext context) :
            base(info, context) {}
    }
}