% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fdebug.r
\name{Fdebug}
\alias{Fdebug}
\title{Debug Printing Function Generator}
\usage{
Fdebug(opt)
}
\arguments{
\item{opt}{character string containing an option name}
}
\value{
a function
}
\description{
Takes the name of a system \code{options(opt=)} and checks to see if option \code{opt} is
set to \code{TRUE}, taking its default value to be \code{FALSE}.  If \code{TRUE}, a function is
created that calls \code{\link[=prn]{prn()}} to print an object with the object's name in the
description along with the option name and the name of the function within which
the generated function was called, if any.  If option \code{opt} is not set, a dummy function
is generated instead.  If \code{options(debug_file=)} is set when the generated function
is called, \code{\link[=prn]{prn()}} output will be appended to that file name instead of the console.
At any time, set \code{options(debug_file='')} to resume printing to the console.
}
\examples{
dfun <- Fdebug('my_option_name')   # my_option_name not currently set
dfun
dfun(sqrt(2))
options(my_option_name=TRUE)
dfun <- Fdebug('my_option_name')
dfun
dfun(sqrt(2))
# options(debug_file='/tmp/z') to append output to /tmp/z
options(my_option_name=NULL)
}
\author{
Fran Harrell
}
