/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(vector_source.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(1176d2a53ecb9fd3818f6f2559576a1e)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/blocks/vector_source.h>
#include <gnuradio/sync_block.h>
#include <gnuradio/tags.h>

template <typename T>
void bind_vector_source_template(py::module& m, const char* classname)
{
    // using vector_source      = gr::blocks::vector_source<T>;


    py::class_<gr::blocks::vector_source<T>,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<gr::blocks::vector_source<T>>>(m, classname)
        .def(py::init(&gr::blocks::vector_source<T>::make),
             py::arg("data"),
             py::arg("repeat") = false,
             py::arg("vlen") = 1,
             py::arg("tags") = std::vector<gr::tag_t>())


        // With these templated classes, the additional class members cause the compiler
        // error
        //  error: expected ‘;’ before ‘)’ token
        //  .def("rewind", &gr::blocks::vector_source<T>::rewind))
        //                                                       ^

        .def("rewind", &gr::blocks::vector_source<T>::rewind)
        .def("set_data",
             &gr::blocks::vector_source<T>::set_data,
             py::arg("data"),
             py::arg("tags") = std::vector<gr::tag_t>())
        .def("set_repeat", &gr::blocks::vector_source<T>::set_repeat, py::arg("repeat"))

        ;
}

void bind_vector_source(py::module& m)
{
    bind_vector_source_template<std::uint8_t>(m, "vector_source_b");
    bind_vector_source_template<std::int16_t>(m, "vector_source_s");
    bind_vector_source_template<std::int32_t>(m, "vector_source_i");
    bind_vector_source_template<float>(m, "vector_source_f");
    bind_vector_source_template<gr_complex>(m, "vector_source_c");
}
