/* SPDX-License-Identifier: GPL-2.0-only */
#ifndef _SOC_ALDERLAKE_GPIO_SOC_DEFS_PCH_S_H_
#define _SOC_ALDERLAKE_GPIO_SOC_DEFS_PCH_S_H_

#define INC(x) ((x) + 1)
/*
 * Most of the fixed numbers and macros are based on the GPP groups.
 * The GPIO groups are accessed through register blocks called
 * communities.
 *
 * Refer to Alder Lake PCH-S EDS Chapter 26, MISCCFG register offset 0x10
 * for each GPIO community to get GPIO group to GPE_DWx assignment.
 */
#define GPP_I			0x0
#define GPP_R			INC(GPP_I)
#define GPP_J			INC(GPP_R)
#define GPP_VPGIO		INC(GPP_J)
#define GPD			INC(GPP_VPGIO)
#define GPP_D			INC(GPD)
#define GPP_S			INC(GPP_D)
#define GPP_E			INC(GPP_S)
#define GPP_K			INC(GPP_E)
#define GPP_F			INC(GPP_K)
#define GPP_A			INC(GPP_F)
#define GPP_C			INC(GPP_A)
#define GPP_B			INC(GPP_C)
#define GPP_G			INC(GPP_B)
#define GPP_H			INC(GPP_G)

#define GPIO_MAX_NUM_PER_GROUP	26

#define COMM_0			0
#define COMM_1			INC(COMM_0)
#define COMM_2			INC(COMM_1)
#define COMM_3			INC(COMM_2)
#define COMM_4			INC(COMM_3)
#define COMM_5			INC(COMM_4)

/* Group I */
#define GPP_I0			0
#define GPP_I1			INC(GPP_I0)
#define GPP_I2			INC(GPP_I1)
#define GPP_I3			INC(GPP_I2)
#define GPP_I4			INC(GPP_I3)
#define GPP_I5			INC(GPP_I4)
#define GPP_I6			INC(GPP_I5)
#define GPP_I7			INC(GPP_I6)
#define GPP_I8			INC(GPP_I7)
#define GPP_I9			INC(GPP_I8)
#define GPP_I10			INC(GPP_I9)
#define GPP_I11			INC(GPP_I10)
#define GPP_I12			INC(GPP_I11)
#define GPP_I13			INC(GPP_I12)
#define GPP_I14			INC(GPP_I13)
#define GPP_I15			INC(GPP_I14)
#define GPP_I16			INC(GPP_I15)
#define GPP_I17			INC(GPP_I16)
#define GPP_I18			INC(GPP_I17)
#define GPP_I19			INC(GPP_I18)
#define GPP_I20			INC(GPP_I19)
#define GPP_I21			INC(GPP_I20)
#define GPP_I22			INC(GPP_I21)
#define GPP_GSPI0_CLK_LOOPBK	INC(GPP_I22)
#define GPP_GSPI1_CLK_LOOPBK	INC(GPP_GSPI0_CLK_LOOPBK)

/* Group R */
#define GPP_R0			INC(GPP_GSPI1_CLK_LOOPBK)
#define GPP_R1			INC(GPP_R0)
#define GPP_R2			INC(GPP_R1)
#define GPP_R3			INC(GPP_R2)
#define GPP_R4			INC(GPP_R3)
#define GPP_R5			INC(GPP_R4)
#define GPP_R6			INC(GPP_R5)
#define GPP_R7			INC(GPP_R6)
#define GPP_R8			INC(GPP_R7)
#define GPP_R9			INC(GPP_R8)
#define GPP_R10			INC(GPP_R9)
#define GPP_R11			INC(GPP_R10)
#define GPP_R12			INC(GPP_R11)
#define GPP_R13			INC(GPP_R12)
#define GPP_R14			INC(GPP_R13)
#define GPP_R15			INC(GPP_R14)
#define GPP_R16			INC(GPP_R15)
#define GPP_R17			INC(GPP_R16)
#define GPP_R18			INC(GPP_R17)
#define GPP_R19			INC(GPP_R18)
#define GPP_R20			INC(GPP_R19)
#define GPP_R21			INC(GPP_R20)
#define GPP_GSPI2_CLK_LOOPBK	INC(GPP_R21)

/* Group J */
#define GPP_J0			INC(GPP_GSPI2_CLK_LOOPBK)
#define GPP_J1			INC(GPP_J0)
#define GPP_J2			INC(GPP_J1)
#define GPP_J3			INC(GPP_J2)
#define GPP_J4			INC(GPP_J3)
#define GPP_J5			INC(GPP_J4)
#define GPP_J6			INC(GPP_J5)
#define GPP_J7			INC(GPP_J6)
#define GPP_J8			INC(GPP_J7)
#define GPP_J9			INC(GPP_J8)
#define GPP_J10			INC(GPP_J9)
#define GPP_J11			INC(GPP_J10)

/* Group vGPIO */
#define VGPIO_0			INC(GPP_J11)
#define VGPIO_4			INC(VGPIO_0)
#define VGPIO_5			INC(VGPIO_4)
#define VGPIO_6			INC(VGPIO_5)
#define VGPIO_7			INC(VGPIO_6)
#define VGPIO_8			INC(VGPIO_7)
#define VGPIO_9			INC(VGPIO_8)
#define VGPIO_10		INC(VGPIO_9)
#define VGPIO_11		INC(VGPIO_10)
#define VGPIO_12		INC(VGPIO_11)
#define VGPIO_13		INC(VGPIO_12)
#define VGPIO_18		INC(VGPIO_13)
#define VGPIO_19		INC(VGPIO_18)
#define VGPIO_20		INC(VGPIO_19)
#define VGPIO_21		INC(VGPIO_20)
#define VGPIO_22		INC(VGPIO_21)
#define VGPIO_23		INC(VGPIO_22)
#define VGPIO_24		INC(VGPIO_23)
#define VGPIO_25		INC(VGPIO_24)
#define VGPIO_30		INC(VGPIO_25)
#define VGPIO_31		INC(VGPIO_30)
#define VGPIO_32		INC(VGPIO_31)
#define VGPIO_33		INC(VGPIO_32)
#define VGPIO_34		INC(VGPIO_33)
#define VGPIO_35		INC(VGPIO_34)
#define VGPIO_36		INC(VGPIO_35)
#define VGPIO_37		INC(VGPIO_36)

/* Group vGPIO_0 */
#define VGPIO_USB_0		INC(VGPIO_37)
#define VGPIO_USB_1		INC(VGPIO_USB_0)
#define VGPIO_USB_2		INC(VGPIO_USB_1)
#define VGPIO_USB_3		INC(VGPIO_USB_2)
#define VGPIO_USB_8		INC(VGPIO_USB_3)
#define VGPIO_USB_9		INC(VGPIO_USB_8)
#define VGPIO_USB_10		INC(VGPIO_USB_9)
#define VGPIO_USB_11		INC(VGPIO_USB_10)

#define GPIO_COM0_START		GPP_I0
#define GPIO_COM0_END		VGPIO_USB_11
#define NUM_GPIO_COM0_PADS	(GPIO_COM0_END - GPIO_COM0_START + 1)

/* Group B */
#define GPP_B0			INC(VGPIO_USB_11)
#define GPP_B1			INC(GPP_B0)
#define GPP_B2			INC(GPP_B1)
#define GPP_B3			INC(GPP_B2)
#define GPP_B4			INC(GPP_B3)
#define GPP_B5			INC(GPP_B4)
#define GPP_B6			INC(GPP_B5)
#define GPP_B7			INC(GPP_B6)
#define GPP_B8			INC(GPP_B7)
#define GPP_B9			INC(GPP_B8)
#define GPP_B10			INC(GPP_B9)
#define GPP_B11			INC(GPP_B10)
#define GPP_B12			INC(GPP_B11)
#define GPP_B13			INC(GPP_B12)
#define GPP_B14			INC(GPP_B13)
#define GPP_B15			INC(GPP_B14)
#define GPP_B16			INC(GPP_B15)
#define GPP_B17			INC(GPP_B16)
#define GPP_B18			INC(GPP_B17)
#define GPP_B19			INC(GPP_B18)
#define GPP_B20			INC(GPP_B19)
#define GPP_B21			INC(GPP_B20)
#define GPP_B22			INC(GPP_B21)
#define GPP_B23			INC(GPP_B22)

/* Group G */
#define GPP_G0			INC(GPP_B23)
#define GPP_G1			INC(GPP_G0)
#define GPP_G2			INC(GPP_G1)
#define GPP_G3			INC(GPP_G2)
#define GPP_G4			INC(GPP_G3)
#define GPP_G5			INC(GPP_G4)
#define GPP_G6			INC(GPP_G5)
#define GPP_G7			INC(GPP_G6)

/* Group H */
#define GPP_H0			INC(GPP_G7)
#define GPP_H1			INC(GPP_H0)
#define GPP_H2			INC(GPP_H1)
#define GPP_H3			INC(GPP_H2)
#define GPP_H4			INC(GPP_H3)
#define GPP_H5			INC(GPP_H4)
#define GPP_H6			INC(GPP_H5)
#define GPP_H7			INC(GPP_H6)
#define GPP_H8			INC(GPP_H7)
#define GPP_H9			INC(GPP_H8)
#define GPP_H10			INC(GPP_H9)
#define GPP_H11			INC(GPP_H10)
#define GPP_H12			INC(GPP_H11)
#define GPP_H13			INC(GPP_H12)
#define GPP_H14			INC(GPP_H13)
#define GPP_H15			INC(GPP_H14)
#define GPP_H16			INC(GPP_H15)
#define GPP_H17			INC(GPP_H16)
#define GPP_H18			INC(GPP_H17)
#define GPP_H19			INC(GPP_H18)
#define GPP_H20			INC(GPP_H19)
#define GPP_H21			INC(GPP_H20)
#define GPP_H22			INC(GPP_H21)
#define GPP_H23			INC(GPP_H22)

#define GPIO_COM1_START		GPP_B0
#define GPIO_COM1_END		GPP_H23
#define NUM_GPIO_COM1_PADS	(GPIO_COM1_END - GPIO_COM1_START + 1)

/* Group GPD */
#define GPD0			INC(GPP_H23)
#define GPD1			INC(GPD0)
#define GPD2			INC(GPD1)
#define GPD3			INC(GPD2)
#define GPD4			INC(GPD3)
#define GPD5			INC(GPD4)
#define GPD6			INC(GPD5)
#define GPD7			INC(GPD6)
#define GPD8			INC(GPD7)
#define GPD9			INC(GPD8)
#define GPD10			INC(GPD9)
#define GPD11			INC(GPD10)
#define GPD12			INC(GPD11)
#define GPD_SLP_LANB		INC(GPD12)
#define GPD_SLP_SUSB		INC(GPD_SLP_LANB)
#define GPD_WAKEB		INC(GPD_SLP_SUSB)
#define GPD_DRAM_RESETB		INC(GPD_WAKEB)

#define GPIO_COM2_START		GPD0
#define GPIO_COM2_END		GPD_DRAM_RESETB
#define NUM_GPIO_COM2_PADS	(GPIO_COM2_END - GPIO_COM2_START + 1)

/* Group SPI */
#define GPP_SPI0_IO_2		INC(GPD_DRAM_RESETB)
#define GPP_SPI0_IO_3		INC(GPP_SPI0_IO_2)
#define GPP_SPI0_MOSI_IO_0	INC(GPP_SPI0_IO_3)
#define GPP_SPI0_MISO_IO_1	INC(GPP_SPI0_MOSI_IO_0)
#define GPP_SPI0_TPM_CSB	INC(GPP_SPI0_MISO_IO_1)
#define GPP_SPI0_FLASH_0_CSB	INC(GPP_SPI0_TPM_CSB)
#define GPP_SPI0_FLASH_1_CSB	INC(GPP_SPI0_FLASH_0_CSB)
#define GPP_SPI0_CLK		INC(GPP_SPI0_FLASH_1_CSB)
#define GPP_SPI0_CLK_LOOPBK	INC(GPP_SPI0_CLK)

/* Group A */
#define GPP_A0			INC(GPP_SPI0_CLK_LOOPBK)
#define GPP_A1			INC(GPP_A0)
#define GPP_A2			INC(GPP_A1)
#define GPP_A3			INC(GPP_A2)
#define GPP_A4			INC(GPP_A3)
#define GPP_A5			INC(GPP_A4)
#define GPP_A6			INC(GPP_A5)
#define GPP_A7			INC(GPP_A6)
#define GPP_A8			INC(GPP_A7)
#define GPP_A9			INC(GPP_A8)
#define GPP_A10			INC(GPP_A9)
#define GPP_A11			INC(GPP_A10)
#define GPP_A12			INC(GPP_A11)
#define GPP_A13			INC(GPP_A12)
#define GPP_A14			INC(GPP_A13)
#define GPP_ESPI_CLK_LOOPBK	INC(GPP_A14)

/* Group C */
#define GPP_C0			INC(GPP_ESPI_CLK_LOOPBK)
#define GPP_C1			INC(GPP_C0)
#define GPP_C2			INC(GPP_C1)
#define GPP_C3			INC(GPP_C2)
#define GPP_C4			INC(GPP_C3)
#define GPP_C5			INC(GPP_C4)
#define GPP_C6			INC(GPP_C5)
#define GPP_C7			INC(GPP_C6)
#define GPP_C8			INC(GPP_C7)
#define GPP_C9			INC(GPP_C8)
#define GPP_C10			INC(GPP_C9)
#define GPP_C11			INC(GPP_C10)
#define GPP_C12			INC(GPP_C11)
#define GPP_C13			INC(GPP_C12)
#define GPP_C14			INC(GPP_C13)
#define GPP_C15			INC(GPP_C14)
#define GPP_C16			INC(GPP_C15)
#define GPP_C17			INC(GPP_C16)
#define GPP_C18			INC(GPP_C17)
#define GPP_C19			INC(GPP_C18)
#define GPP_C20			INC(GPP_C19)
#define GPP_C21			INC(GPP_C20)
#define GPP_C22			INC(GPP_C21)
#define GPP_C23			INC(GPP_C22)

/* Group vGPIO_3 */
#define VGPIO_PCIE_0		INC(GPP_C23)
#define VGPIO_PCIE_1		INC(VGPIO_PCIE_0)
#define VGPIO_PCIE_2		INC(VGPIO_PCIE_1)
#define VGPIO_PCIE_3		INC(VGPIO_PCIE_2)
#define VGPIO_PCIE_4		INC(VGPIO_PCIE_3)
#define VGPIO_PCIE_5		INC(VGPIO_PCIE_4)
#define VGPIO_PCIE_6		INC(VGPIO_PCIE_5)
#define VGPIO_PCIE_7		INC(VGPIO_PCIE_6)
#define VGPIO_PCIE_8		INC(VGPIO_PCIE_7)
#define VGPIO_PCIE_9		INC(VGPIO_PCIE_8)
#define VGPIO_PCIE_10		INC(VGPIO_PCIE_9)
#define VGPIO_PCIE_11		INC(VGPIO_PCIE_10)
#define VGPIO_PCIE_12		INC(VGPIO_PCIE_11)
#define VGPIO_PCIE_13		INC(VGPIO_PCIE_12)
#define VGPIO_PCIE_14		INC(VGPIO_PCIE_13)
#define VGPIO_PCIE_15		INC(VGPIO_PCIE_14)
#define VGPIO_PCIE_16		INC(VGPIO_PCIE_15)
#define VGPIO_PCIE_17		INC(VGPIO_PCIE_16)
#define VGPIO_PCIE_18		INC(VGPIO_PCIE_17)
#define VGPIO_PCIE_19		INC(VGPIO_PCIE_18)
#define VGPIO_PCIE_20		INC(VGPIO_PCIE_19)
#define VGPIO_PCIE_21		INC(VGPIO_PCIE_20)
#define VGPIO_PCIE_22		INC(VGPIO_PCIE_21)
#define VGPIO_PCIE_23		INC(VGPIO_PCIE_22)
#define VGPIO_PCIE_24		INC(VGPIO_PCIE_23)
#define VGPIO_PCIE_25		INC(VGPIO_PCIE_24)
#define VGPIO_PCIE_26		INC(VGPIO_PCIE_25)
#define VGPIO_PCIE_27		INC(VGPIO_PCIE_26)
#define VGPIO_PCIE_28		INC(VGPIO_PCIE_27)
#define VGPIO_PCIE_29		INC(VGPIO_PCIE_28)
#define VGPIO_PCIE_30		INC(VGPIO_PCIE_29)
#define VGPIO_PCIE_31		INC(VGPIO_PCIE_30)
#define VGPIO_PCIE_32		INC(VGPIO_PCIE_31)
#define VGPIO_PCIE_33		INC(VGPIO_PCIE_32)
#define VGPIO_PCIE_34		INC(VGPIO_PCIE_33)
#define VGPIO_PCIE_35		INC(VGPIO_PCIE_34)
#define VGPIO_PCIE_36		INC(VGPIO_PCIE_35)
#define VGPIO_PCIE_37		INC(VGPIO_PCIE_36)
#define VGPIO_PCIE_38		INC(VGPIO_PCIE_37)
#define VGPIO_PCIE_39		INC(VGPIO_PCIE_38)
#define VGPIO_PCIE_40		INC(VGPIO_PCIE_39)
#define VGPIO_PCIE_41		INC(VGPIO_PCIE_40)
#define VGPIO_PCIE_42		INC(VGPIO_PCIE_41)
#define VGPIO_PCIE_43		INC(VGPIO_PCIE_42)
#define VGPIO_PCIE_44		INC(VGPIO_PCIE_43)
#define VGPIO_PCIE_45		INC(VGPIO_PCIE_44)
#define VGPIO_PCIE_46		INC(VGPIO_PCIE_45)
#define VGPIO_PCIE_47		INC(VGPIO_PCIE_46)
#define VGPIO_PCIE_48		INC(VGPIO_PCIE_47)
#define VGPIO_PCIE_49		INC(VGPIO_PCIE_48)
#define VGPIO_PCIE_50		INC(VGPIO_PCIE_49)
#define VGPIO_PCIE_51		INC(VGPIO_PCIE_50)
#define VGPIO_PCIE_52		INC(VGPIO_PCIE_51)
#define VGPIO_PCIE_53		INC(VGPIO_PCIE_52)
#define VGPIO_PCIE_54		INC(VGPIO_PCIE_53)
#define VGPIO_PCIE_55		INC(VGPIO_PCIE_54)
#define VGPIO_PCIE_56		INC(VGPIO_PCIE_55)
#define VGPIO_PCIE_57		INC(VGPIO_PCIE_56)
#define VGPIO_PCIE_58		INC(VGPIO_PCIE_57)
#define VGPIO_PCIE_59		INC(VGPIO_PCIE_58)
#define VGPIO_PCIE_60		INC(VGPIO_PCIE_59)
#define VGPIO_PCIE_61		INC(VGPIO_PCIE_60)
#define VGPIO_PCIE_62		INC(VGPIO_PCIE_61)
#define VGPIO_PCIE_63		INC(VGPIO_PCIE_62)
#define VGPIO_PCIE_64		INC(VGPIO_PCIE_63)
#define VGPIO_PCIE_65		INC(VGPIO_PCIE_64)
#define VGPIO_PCIE_66		INC(VGPIO_PCIE_65)
#define VGPIO_PCIE_67		INC(VGPIO_PCIE_66)
#define VGPIO_PCIE_68		INC(VGPIO_PCIE_67)
#define VGPIO_PCIE_69		INC(VGPIO_PCIE_68)
#define VGPIO_PCIE_70		INC(VGPIO_PCIE_69)
#define VGPIO_PCIE_71		INC(VGPIO_PCIE_70)
#define VGPIO_PCIE_72		INC(VGPIO_PCIE_71)
#define VGPIO_PCIE_73		INC(VGPIO_PCIE_72)
#define VGPIO_PCIE_74		INC(VGPIO_PCIE_73)
#define VGPIO_PCIE_75		INC(VGPIO_PCIE_74)
#define VGPIO_PCIE_76		INC(VGPIO_PCIE_75)
#define VGPIO_PCIE_77		INC(VGPIO_PCIE_76)
#define VGPIO_PCIE_78		INC(VGPIO_PCIE_77)
#define VGPIO_PCIE_79		INC(VGPIO_PCIE_78)
#define VGPIO_PCIE_80		INC(VGPIO_PCIE_79)
#define VGPIO_PCIE_81		INC(VGPIO_PCIE_80)
#define VGPIO_PCIE_82		INC(VGPIO_PCIE_81)
#define VGPIO_PCIE_83		INC(VGPIO_PCIE_82)

#define GPIO_COM3_START		GPP_SPI0_IO_2
#define GPIO_COM3_END		VGPIO_PCIE_83
#define NUM_GPIO_COM3_PADS	(GPIO_COM3_END - GPIO_COM3_START + 1)

/* Group S */
#define GPP_S0			INC(VGPIO_PCIE_83)
#define GPP_S1			INC(GPP_S0)
#define GPP_S2			INC(GPP_S1)
#define GPP_S3			INC(GPP_S2)
#define GPP_S4			INC(GPP_S3)
#define GPP_S5			INC(GPP_S4)
#define GPP_S6			INC(GPP_S5)
#define GPP_S7			INC(GPP_S6)

/* Group E */
#define GPP_E0				INC(GPP_S7)
#define GPP_E1				INC(GPP_E0)
#define GPP_E2				INC(GPP_E1)
#define GPP_E3				INC(GPP_E2)
#define GPP_E4				INC(GPP_E3)
#define GPP_E5				INC(GPP_E4)
#define GPP_E6				INC(GPP_E5)
#define GPP_E7				INC(GPP_E6)
#define GPP_E8				INC(GPP_E7)
#define GPP_E9				INC(GPP_E8)
#define GPP_E10				INC(GPP_E9)
#define GPP_E11				INC(GPP_E10)
#define GPP_E12				INC(GPP_E11)
#define GPP_E13				INC(GPP_E12)
#define GPP_E14				INC(GPP_E13)
#define GPP_E15				INC(GPP_E14)
#define GPP_E16				INC(GPP_E15)
#define GPP_E17				INC(GPP_E16)
#define GPP_E18				INC(GPP_E17)
#define GPP_E19				INC(GPP_E18)
#define GPP_E20				INC(GPP_E19)
#define GPP_E21				INC(GPP_E20)
#define GPP_SPI1_THC0_CLK_LOOPBK	INC(GPP_E21)

/* Group K */
#define GPP_K0			INC(GPP_SPI1_THC0_CLK_LOOPBK)
#define GPP_K1			INC(GPP_K0)
#define GPP_K2			INC(GPP_K1)
#define GPP_K3			INC(GPP_K2)
#define GPP_K4			INC(GPP_K3)
#define GPP_K5			INC(GPP_K4)
#define GPP_K6			INC(GPP_K5)
#define GPP_K7			INC(GPP_K6)
#define GPP_K8			INC(GPP_K7)
#define GPP_K9			INC(GPP_K8)
#define GPP_K10			INC(GPP_K9)
#define GPP_K11			INC(GPP_K10)
#define GPP_SYS_PWROK		INC(GPP_K11)
#define GPP_SYS_RESETB		INC(GPP_SYS_PWROK)
#define GPP_MLK_RSTB		INC(GPP_SYS_RESETB)

/* Group F */
#define GPP_F0			INC(GPP_MLK_RSTB)
#define GPP_F1			INC(GPP_F0)
#define GPP_F2			INC(GPP_F1)
#define GPP_F3			INC(GPP_F2)
#define GPP_F4			INC(GPP_F3)
#define GPP_F5			INC(GPP_F4)
#define GPP_F6			INC(GPP_F5)
#define GPP_F7			INC(GPP_F6)
#define GPP_F8			INC(GPP_F7)
#define GPP_F9			INC(GPP_F8)
#define GPP_F10			INC(GPP_F9)
#define GPP_F11			INC(GPP_F10)
#define GPP_F12			INC(GPP_F11)
#define GPP_F13			INC(GPP_F12)
#define GPP_F14			INC(GPP_F13)
#define GPP_F15			INC(GPP_F14)
#define GPP_F16			INC(GPP_F15)
#define GPP_F17			INC(GPP_F16)
#define GPP_F18			INC(GPP_F17)
#define GPP_F19			INC(GPP_F18)
#define GPP_F20			INC(GPP_F19)
#define GPP_F21			INC(GPP_F20)
#define GPP_F22			INC(GPP_F21)
#define GPP_F23			INC(GPP_F22)

#define GPIO_COM4_START		GPP_S0
#define GPIO_COM4_END		GPP_F23
#define NUM_GPIO_COM4_PADS	(GPIO_COM4_END - GPIO_COM4_START + 1)

/* Group D */
#define GPP_D0				INC(GPP_F23)
#define GPP_D1				INC(GPP_D0)
#define GPP_D2				INC(GPP_D1)
#define GPP_D3				INC(GPP_D2)
#define GPP_D4				INC(GPP_D3)
#define GPP_D5				INC(GPP_D4)
#define GPP_D6				INC(GPP_D5)
#define GPP_D7				INC(GPP_D6)
#define GPP_D8				INC(GPP_D7)
#define GPP_D9				INC(GPP_D8)
#define GPP_D10				INC(GPP_D9)
#define GPP_D11				INC(GPP_D10)
#define GPP_D12				INC(GPP_D11)
#define GPP_D13				INC(GPP_D12)
#define GPP_D14				INC(GPP_D13)
#define GPP_D15				INC(GPP_D14)
#define GPP_D16				INC(GPP_D15)
#define GPP_D17				INC(GPP_D16)
#define GPP_D18				INC(GPP_D17)
#define GPP_D19				INC(GPP_D18)
#define GPP_D20				INC(GPP_D19)
#define GPP_D21				INC(GPP_D20)
#define GPP_D22				INC(GPP_D21)
#define GPP_D23				INC(GPP_D22)
#define GPP_GSPI3_THC1_CLK_LOOPBK	INC(GPP_D23)

/* Group JTAG */
#define GPP_JTAG_TDO		INC(GPP_GSPI3_THC1_CLK_LOOPBK)
#define GPP_JTAGX		INC(GPP_JTAG_TDO)
#define GPP_PRDYB		INC(GPP_JTAGX)
#define GPP_PREQB		INC(GPP_PRDYB)
#define GPP_JTAG_TDI		INC(GPP_PREQB)
#define GPP_JTAG_TMS		INC(GPP_JTAG_TDI)
#define GPP_JTAG_TCK		INC(GPP_JTAG_TMS)
#define GPP_DBG_PMODE		INC(GPP_JTAG_TCK)
#define GPP_CPU_TRSTB		INC(GPP_DBG_PMODE)

/* Group CPU */
#define GPP_HDACPU_SDI		INC(GPP_CPU_TRSTB)
#define GPP_HDACPU_SDO		INC(GPP_HDACPU_SDI)
#define GPP_HDACPU_SCLK		INC(GPP_HDACPU_SDO)
#define GPP_PM_SYNC		INC(GPP_HDACPU_SCLK)
#define GPP_PECI		INC(GPP_PM_SYNC)
#define GPP_CPUPWRGD		INC(GPP_PECI)
#define GPP_THRMTRIPB		INC(GPP_CPUPWRGD)
#define GPP_PLTRST_CPUB		INC(GPP_THRMTRIPB)
#define GPP_PM_DOWN		INC(GPP_PLTRST_CPUB)
#define GPP_TRIGGER_IN		INC(GPP_PM_DOWN)
#define GPP_TRIGGER_OUT		INC(GPP_TRIGGER_IN)
#define GPP_CLKOUT_CPURTC	INC(GPP_TRIGGER_OUT)
#define GPP_VCCST_OVERRIDE	INC(GPP_CLKOUT_CPURTC)
#define GPP_C10_WAKE		INC(GPP_VCCST_OVERRIDE)

#define GPIO_COM5_START		GPP_D0
#define GPIO_COM5_END		GPP_C10_WAKE
#define NUM_GPIO_COM5_PADS	(GPIO_COM5_END - GPIO_COM5_START + 1)

#define TOTAL_GPIO_COMM		(COMM_5 + 1)
#define TOTAL_PADS		(GPIO_COM5_END + 1)

#endif
