/*
 * MoleculesToTriangles/CXXClasses/SolidColorRule.cpp
 *
 * Copyright 2009 by Martin Noble, University of Oxford
 * Author: Martin Noble
 *
 * This file is part of Coot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA
 */
#include <algorithm>
#include <sstream>
#include "SolidColorRule.h"

std::pair<std::string, FCXXCoord  > SolidColorRule::nameColorPairs[] = {
    std::pair<std::string, FCXXCoord  >("RED1", FCXXCoord ( 1.0, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("GREEN", FCXXCoord ( 0.0, 1.0, 0)),
    std::pair<std::string, FCXXCoord  >("BLUE", FCXXCoord ( 0.0, 0.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("CYAN", FCXXCoord ( 0.0, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("MAGENTA", FCXXCoord ( 1.0, 0.0, 1)),
    std::pair<std::string, FCXXCoord  >("YELLOW", FCXXCoord ( 1.0, 1.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("ORANGE", FCXXCoord ( 1.0, 0.647059, 0)),
    std::pair<std::string, FCXXCoord  >("PURPLE", FCXXCoord ( 0.627451, 0.12549, 0.941176)),
    std::pair<std::string, FCXXCoord  >("ANTIQUEWHITE2", FCXXCoord ( 0.933333, 0.87451, 0.8)),
    std::pair<std::string, FCXXCoord  >("GAINSBORO", FCXXCoord ( 0.862745, 0.862745, 0.862745)),
    std::pair<std::string, FCXXCoord  >("HONEYDEW", FCXXCoord ( 0.941176, 1.0, 0.941176)),
    std::pair<std::string, FCXXCoord  >("MISTYROSE", FCXXCoord ( 1.0, 0.894118, 0.882353)),
    std::pair<std::string, FCXXCoord  >("SLATEGREY", FCXXCoord ( 0.439216, 0.501961, 0.564706)),
    std::pair<std::string, FCXXCoord  >("SKYBLUE", FCXXCoord ( 0.529412, 0.807843, 0.921569)),
    std::pair<std::string, FCXXCoord  >("LIGHT_STEEL_BLUE", FCXXCoord ( 0.690196, 0.768627, 0.870588)),
    std::pair<std::string, FCXXCoord  >("LIGHTCYAN", FCXXCoord ( 0.878431, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("LIMEGREEN", FCXXCoord ( 0.196078, 0.803922, 0.196078)),
    std::pair<std::string, FCXXCoord  >("YELLOWGREEN", FCXXCoord ( 0.603922, 0.803922, 0.196078)),
    std::pair<std::string, FCXXCoord  >("GOLDENROD", FCXXCoord ( 0.854902, 0.647059, 0.12549)),
    std::pair<std::string, FCXXCoord  >("PERU", FCXXCoord ( 0.803922, 0.521569, 0.247059)),
    std::pair<std::string, FCXXCoord  >("LIGHT_SALMON", FCXXCoord ( 1.0, 0.627451, 0.478431)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_VIOLET_RED", FCXXCoord ( 0.780392, 0.0823529, 0.521569)),
    std::pair<std::string, FCXXCoord  >("SNOW4", FCXXCoord ( 0.545098, 0.537255, 0.537255)),
    std::pair<std::string, FCXXCoord  >("BISQUE2", FCXXCoord ( 0.933333, 0.835294, 0.717647)),
    std::pair<std::string, FCXXCoord  >("BISQUE3", FCXXCoord ( 0.803922, 0.717647, 0.619608)),
    std::pair<std::string, FCXXCoord  >("AZURE1", FCXXCoord ( 0.941176, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("SLATEBLUE1", FCXXCoord ( 0.513725, 0.435294, 1)),
    std::pair<std::string, FCXXCoord  >("SLATEBLUE4", FCXXCoord ( 0.278431, 0.235294, 0.545098)),
    std::pair<std::string, FCXXCoord  >("SKYBLUE1", FCXXCoord ( 0.529412, 0.807843, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTSKYBLUE3", FCXXCoord ( 0.552941, 0.713725, 0.803922)),
    std::pair<std::string, FCXXCoord  >("PALETURQUOISE4", FCXXCoord ( 0.4, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("CADETBLUE2", FCXXCoord ( 0.556863, 0.898039, 0.933333)),
    std::pair<std::string, FCXXCoord  >("AQUAMARINE4", FCXXCoord ( 0.270588, 0.545098, 0.454902)),
    std::pair<std::string, FCXXCoord  >("SPRINGGREEN2", FCXXCoord ( 0.0, 0.933333, 0.462745)),
    std::pair<std::string, FCXXCoord  >("OLIVEDRAB1", FCXXCoord ( 0.752941, 1.0, 0.243137)),
    std::pair<std::string, FCXXCoord  >("YELLOW2", FCXXCoord ( 0.933333, 0.933333, 0)),
    std::pair<std::string, FCXXCoord  >("GOLDENROD3", FCXXCoord ( 0.803922, 0.607843, 0.113725)),
    std::pair<std::string, FCXXCoord  >("GOLDENROD4", FCXXCoord ( 0.545098, 0.411765, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("BURLYWOOD1", FCXXCoord ( 1.0, 0.827451, 0.607843)),
    std::pair<std::string, FCXXCoord  >("ORANGE3", FCXXCoord ( 0.803922, 0.521569, 0)),
    std::pair<std::string, FCXXCoord  >("TOMATO3", FCXXCoord ( 0.803922, 0.309804, 0.223529)),
    std::pair<std::string, FCXXCoord  >("DARKORCHID2", FCXXCoord ( 0.698039, 0.227451, 0.933333)),
    std::pair<std::string, FCXXCoord  >("PURPLE4", FCXXCoord ( 0.333333, 0.101961, 0.545098)),
    std::pair<std::string, FCXXCoord  >("MEDIUMPURPLE2", FCXXCoord ( 0.623529, 0.47451, 0.933333)),
    std::pair<std::string, FCXXCoord  >("GRAY26", FCXXCoord ( 0.258824, 0.258824, 0.258824)),
    std::pair<std::string, FCXXCoord  >("GRAY33", FCXXCoord ( 0.329412, 0.329412, 0.329412)),
    std::pair<std::string, FCXXCoord  >("GREY34", FCXXCoord ( 0.341176, 0.341176, 0.341176)),
    std::pair<std::string, FCXXCoord  >("GRAY37", FCXXCoord ( 0.368627, 0.368627, 0.368627)),
    std::pair<std::string, FCXXCoord  >("GRAY44", FCXXCoord ( 0.439216, 0.439216, 0.439216)),
    std::pair<std::string, FCXXCoord  >("GRAY63", FCXXCoord ( 0.631373, 0.631373, 0.631373)),
    std::pair<std::string, FCXXCoord  >("GRAY99", FCXXCoord ( 0.988235, 0.988235, 0.988235)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_0", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY12", FCXXCoord ( 0.117647, 0.117647, 0.117647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_24", FCXXCoord ( 0.239216, 0.239216, 0.239216)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_36", FCXXCoord ( 0.356863, 0.356863, 0.356863)),
    std::pair<std::string, FCXXCoord  >("SGIGREY44", FCXXCoord ( 0.439216, 0.439216, 0.439216)),
    std::pair<std::string, FCXXCoord  >("SGIGREY96", FCXXCoord ( 0.956863, 0.956863, 0.956863)),
    std::pair<std::string, FCXXCoord  >("SGICHARTREUSE", FCXXCoord ( 0.443137, 0.776471, 0.443137)),
    std::pair<std::string, FCXXCoord  >("SGI_BRIGHT_GRAY", FCXXCoord ( 0.772549, 0.756863, 0.666667)),
    std::pair<std::string, FCXXCoord  >("DEEP_SKY_BLUE", FCXXCoord ( 0.0, 0.74902, 1)),
    std::pair<std::string, FCXXCoord  >("DARKGREEN", FCXXCoord ( 0.0, 0.392157, 0)),
    std::pair<std::string, FCXXCoord  >("DARK_KHAKI", FCXXCoord ( 0.741176, 0.717647, 0.419608)),
    std::pair<std::string, FCXXCoord  >("WHEAT", FCXXCoord ( 0.960784, 0.870588, 0.701961)),
    std::pair<std::string, FCXXCoord  >("DARK_ORANGE", FCXXCoord ( 1.0, 0.54902, 0)),
    std::pair<std::string, FCXXCoord  >("CORAL", FCXXCoord ( 1.0, 0.498039, 0.313725)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_PURPLE", FCXXCoord ( 0.576471, 0.439216, 0.858824)),
    std::pair<std::string, FCXXCoord  >("THISTLE", FCXXCoord ( 0.847059, 0.74902, 0.847059)),
    std::pair<std::string, FCXXCoord  >("NAVAJOWHITE3", FCXXCoord ( 0.803922, 0.701961, 0.545098)),
    std::pair<std::string, FCXXCoord  >("LEMONCHIFFON1", FCXXCoord ( 1.0, 0.980392, 0.803922)),
    std::pair<std::string, FCXXCoord  >("HONEYDEW1", FCXXCoord ( 0.941176, 1.0, 0.941176)),
    std::pair<std::string, FCXXCoord  >("PALETURQUOISE1", FCXXCoord ( 0.733333, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("GOLDENROD2", FCXXCoord ( 0.933333, 0.705882, 0.133333)),
    std::pair<std::string, FCXXCoord  >("BURLYWOOD2", FCXXCoord ( 0.933333, 0.772549, 0.568627)),
    std::pair<std::string, FCXXCoord  >("TAN4", FCXXCoord ( 0.545098, 0.352941, 0.168627)),
    std::pair<std::string, FCXXCoord  >("CHOCOLATE2", FCXXCoord ( 0.933333, 0.462745, 0.129412)),
    std::pair<std::string, FCXXCoord  >("BROWN4", FCXXCoord ( 0.545098, 0.137255, 0.137255)),
    std::pair<std::string, FCXXCoord  >("MAROON1", FCXXCoord ( 1.0, 0.203922, 0.701961)),
    std::pair<std::string, FCXXCoord  >("MAROON2", FCXXCoord ( 0.933333, 0.188235, 0.654902)),
    std::pair<std::string, FCXXCoord  >("DARKORCHID1", FCXXCoord ( 0.74902, 0.243137, 1)),
    std::pair<std::string, FCXXCoord  >("MEDIUMPURPLE1", FCXXCoord ( 0.670588, 0.509804, 1)),
    std::pair<std::string, FCXXCoord  >("THISTLE1", FCXXCoord ( 1.0, 0.882353, 1)),
    std::pair<std::string, FCXXCoord  >("THISTLE2", FCXXCoord ( 0.933333, 0.823529, 0.933333)),
    std::pair<std::string, FCXXCoord  >("THISTLE3", FCXXCoord ( 0.803922, 0.709804, 0.803922)),
    std::pair<std::string, FCXXCoord  >("GRAY16", FCXXCoord ( 0.160784, 0.160784, 0.160784)),
    std::pair<std::string, FCXXCoord  >("GRAY23", FCXXCoord ( 0.231373, 0.231373, 0.231373)),
    std::pair<std::string, FCXXCoord  >("GREY25", FCXXCoord ( 0.25098, 0.25098, 0.25098)),
    std::pair<std::string, FCXXCoord  >("GRAY27", FCXXCoord ( 0.270588, 0.270588, 0.270588)),
    std::pair<std::string, FCXXCoord  >("GRAY35", FCXXCoord ( 0.34902, 0.34902, 0.34902)),
    std::pair<std::string, FCXXCoord  >("GRAY41", FCXXCoord ( 0.411765, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("GREY44", FCXXCoord ( 0.439216, 0.439216, 0.439216)),
    std::pair<std::string, FCXXCoord  >("GRAY45", FCXXCoord ( 0.45098, 0.45098, 0.45098)),
    std::pair<std::string, FCXXCoord  >("GREY53", FCXXCoord ( 0.529412, 0.529412, 0.529412)),
    std::pair<std::string, FCXXCoord  >("GRAY74", FCXXCoord ( 0.741176, 0.741176, 0.741176)),
    std::pair<std::string, FCXXCoord  >("DARKBLUE", FCXXCoord ( 0.0, 0.0, 0.0,.545098)),
    std::pair<std::string, FCXXCoord  >("SGIGREY4", FCXXCoord ( 0.0392157, 0.0392157, 0.0392157)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_16", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY28", FCXXCoord ( 0.278431, 0.278431, 0.278431)),
    std::pair<std::string, FCXXCoord  >("SGIGREY28", FCXXCoord ( 0.278431, 0.278431, 0.278431)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_48", FCXXCoord ( 0.478431, 0.478431, 0.478431)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_84", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("SGIGREY88", FCXXCoord ( 0.878431, 0.878431, 0.878431)),
    std::pair<std::string, FCXXCoord  >("SGILIGHTBLUE", FCXXCoord ( 0.490196, 0.619608, 0.752941)),
    std::pair<std::string, FCXXCoord  >("SGISLATEBLUE", FCXXCoord ( 0.443137, 0.443137, 0.776471)),
    std::pair<std::string, FCXXCoord  >("NAVY_BLUE", FCXXCoord ( 0.0, 0.0, 0.0,.501961)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_SPRING_GREEN", FCXXCoord ( 0.0, 0.980392, 0.603922)),
    std::pair<std::string, FCXXCoord  >("OLIVE_DRAB", FCXXCoord ( 0.419608, 0.556863, 0.137255)),
    std::pair<std::string, FCXXCoord  >("DARKGOLDENROD", FCXXCoord ( 0.721569, 0.52549, 0.0431373)),
    std::pair<std::string, FCXXCoord  >("ROSYBROWN", FCXXCoord ( 0.737255, 0.560784, 0.560784)),
    std::pair<std::string, FCXXCoord  >("VIOLETRED", FCXXCoord ( 0.815686, 0.12549, 0.564706)),
    std::pair<std::string, FCXXCoord  >("SLATEBLUE3", FCXXCoord ( 0.411765, 0.34902, 0.803922)),
    std::pair<std::string, FCXXCoord  >("DEEPSKYBLUE2", FCXXCoord ( 0.0, 0.698039, 0.933333)),
    std::pair<std::string, FCXXCoord  >("DEEPSKYBLUE3", FCXXCoord ( 0.0, 0.603922, 0.803922)),
    std::pair<std::string, FCXXCoord  >("DEEPSKYBLUE4", FCXXCoord ( 0.0, 0.407843, 0.545098)),
    std::pair<std::string, FCXXCoord  >("CADETBLUE4", FCXXCoord ( 0.32549, 0.52549, 0.545098)),
    std::pair<std::string, FCXXCoord  >("INDIANRED1", FCXXCoord ( 1.0, 0.415686, 0.415686)),
    std::pair<std::string, FCXXCoord  >("WHEAT4", FCXXCoord ( 0.545098, 0.494118, 0.4)),
    std::pair<std::string, FCXXCoord  >("FIREBRICK1", FCXXCoord ( 1.0, 0.188235, 0.188235)),
    std::pair<std::string, FCXXCoord  >("LIGHTSALMON2", FCXXCoord ( 0.933333, 0.584314, 0.447059)),
    std::pair<std::string, FCXXCoord  >("DARKORANGE1", FCXXCoord ( 1.0, 0.498039, 0)),
    std::pair<std::string, FCXXCoord  >("GREY61", FCXXCoord ( 0.611765, 0.611765, 0.611765)),
    std::pair<std::string, FCXXCoord  >("GRAY65", FCXXCoord ( 0.65098, 0.65098, 0.65098)),
    std::pair<std::string, FCXXCoord  >("GREY100", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("DARK_RED", FCXXCoord ( 0.545098, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("SGIGREY36", FCXXCoord ( 0.356863, 0.356863, 0.356863)),
    std::pair<std::string, FCXXCoord  >("SGIGREY40", FCXXCoord ( 0.4, 0.4, 0.4)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_88", FCXXCoord ( 0.878431, 0.878431, 0.878431)),
    std::pair<std::string, FCXXCoord  >("CRIMSON", FCXXCoord ( 0.862745, 0.0784314, 0.235294)),
    std::pair<std::string, FCXXCoord  >("FLORALWHITE", FCXXCoord ( 1.0, 0.980392, 0.941176)),
    std::pair<std::string, FCXXCoord  >("LEMON_CHIFFON", FCXXCoord ( 1.0, 0.980392, 0.803922)),
    std::pair<std::string, FCXXCoord  >("LIGHT_SLATE_GREY", FCXXCoord ( 0.466667, 0.533333, 0.6)),
    std::pair<std::string, FCXXCoord  >("MEDIUMBLUE", FCXXCoord ( 0.0, 0.0, 0.0,.803922)),
    std::pair<std::string, FCXXCoord  >("DODGER_BLUE", FCXXCoord ( 0.117647, 0.564706, 1)),
    std::pair<std::string, FCXXCoord  >("STEELBLUE", FCXXCoord ( 0.27451, 0.509804, 0.705882)),
    std::pair<std::string, FCXXCoord  >("TURQUOISE", FCXXCoord ( 0.25098, 0.878431, 0.815686)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_AQUAMARINE", FCXXCoord ( 0.4, 0.803922, 0.666667)),
    std::pair<std::string, FCXXCoord  >("SEA_GREEN", FCXXCoord ( 0.180392, 0.545098, 0.341176)),
    std::pair<std::string, FCXXCoord  >("SEAGREEN", FCXXCoord ( 0.180392, 0.545098, 0.341176)),
    std::pair<std::string, FCXXCoord  >("LAWNGREEN", FCXXCoord ( 0.486275, 0.988235, 0)),
    std::pair<std::string, FCXXCoord  >("LIGHTYELLOW", FCXXCoord ( 1.0, 1.0, 0.0,.878431)),
    std::pair<std::string, FCXXCoord  >("DARK_GOLDENROD", FCXXCoord ( 0.721569, 0.52549, 0.0431373)),
    std::pair<std::string, FCXXCoord  >("BROWN", FCXXCoord ( 0.647059, 0.164706, 0.164706)),
    std::pair<std::string, FCXXCoord  >("VIOLET", FCXXCoord ( 0.933333, 0.509804, 0.933333)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_ORCHID", FCXXCoord ( 0.729412, 0.333333, 0.827451)),
    std::pair<std::string, FCXXCoord  >("NAVAJOWHITE4", FCXXCoord ( 0.545098, 0.47451, 0.368627)),
    std::pair<std::string, FCXXCoord  >("IVORY1", FCXXCoord ( 1.0, 1.0, 0.0,.941176)),
    std::pair<std::string, FCXXCoord  >("HONEYDEW4", FCXXCoord ( 0.513725, 0.545098, 0.513725)),
    std::pair<std::string, FCXXCoord  >("DEEPSKYBLUE1", FCXXCoord ( 0.0, 0.74902, 1)),
    std::pair<std::string, FCXXCoord  >("DARKOLIVEGREEN3", FCXXCoord ( 0.635294, 0.803922, 0.352941)),
    std::pair<std::string, FCXXCoord  >("LIGHTGOLDENROD3", FCXXCoord ( 0.803922, 0.745098, 0.439216)),
    std::pair<std::string, FCXXCoord  >("DARKGOLDENROD1", FCXXCoord ( 1.0, 0.72549, 0.0588235)),
    std::pair<std::string, FCXXCoord  >("BURLYWOOD4", FCXXCoord ( 0.545098, 0.45098, 0.333333)),
    std::pair<std::string, FCXXCoord  >("WHEAT1", FCXXCoord ( 1.0, 0.905882, 0.729412)),
    std::pair<std::string, FCXXCoord  >("CHOCOLATE3", FCXXCoord ( 0.803922, 0.4, 0.113725)),
    std::pair<std::string, FCXXCoord  >("CHOCOLATE4", FCXXCoord ( 0.545098, 0.270588, 0.0745098)),
    std::pair<std::string, FCXXCoord  >("PINK2", FCXXCoord ( 0.933333, 0.662745, 0.721569)),
    std::pair<std::string, FCXXCoord  >("ORCHID4", FCXXCoord ( 0.545098, 0.278431, 0.537255)),
    std::pair<std::string, FCXXCoord  >("GRAY0", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("GREY4", FCXXCoord ( 0.0392157, 0.0392157, 0.0392157)),
    std::pair<std::string, FCXXCoord  >("GREY5", FCXXCoord ( 0.0509804, 0.0509804, 0.0509804)),
    std::pair<std::string, FCXXCoord  >("GREY17", FCXXCoord ( 0.168627, 0.168627, 0.168627)),
    std::pair<std::string, FCXXCoord  >("GRAY29", FCXXCoord ( 0.290196, 0.290196, 0.290196)),
    std::pair<std::string, FCXXCoord  >("GREY30", FCXXCoord ( 0.301961, 0.301961, 0.301961)),
    std::pair<std::string, FCXXCoord  >("GREY46", FCXXCoord ( 0.458824, 0.458824, 0.458824)),
    std::pair<std::string, FCXXCoord  >("GRAY47", FCXXCoord ( 0.470588, 0.470588, 0.470588)),
    std::pair<std::string, FCXXCoord  >("GREY47", FCXXCoord ( 0.470588, 0.470588, 0.470588)),
    std::pair<std::string, FCXXCoord  >("GREY48", FCXXCoord ( 0.478431, 0.478431, 0.478431)),
    std::pair<std::string, FCXXCoord  >("GREY55", FCXXCoord ( 0.54902, 0.54902, 0.54902)),
    std::pair<std::string, FCXXCoord  >("GREY56", FCXXCoord ( 0.560784, 0.560784, 0.560784)),
    std::pair<std::string, FCXXCoord  >("GREY57", FCXXCoord ( 0.568627, 0.568627, 0.568627)),
    std::pair<std::string, FCXXCoord  >("GREY85", FCXXCoord ( 0.85098, 0.85098, 0.85098)),
    std::pair<std::string, FCXXCoord  >("GREY88", FCXXCoord ( 0.878431, 0.878431, 0.878431)),
    std::pair<std::string, FCXXCoord  >("DARK_GRAY", FCXXCoord ( 0.662745, 0.662745, 0.662745)),
    std::pair<std::string, FCXXCoord  >("LIGHTGREEN", FCXXCoord ( 0.564706, 0.933333, 0.564706)),
    std::pair<std::string, FCXXCoord  >("SGIGREY0", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_8", FCXXCoord ( 0.0784314, 0.0784314, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY24", FCXXCoord ( 0.239216, 0.239216, 0.239216)),
    std::pair<std::string, FCXXCoord  >("SGIGREY64", FCXXCoord ( 0.639216, 0.639216, 0.639216)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY84", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("SGI_VERY_LIGHT_GREY", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("DIM_GREY", FCXXCoord ( 0.411765, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("LIGHTSLATEGREY", FCXXCoord ( 0.466667, 0.533333, 0.6)),
    std::pair<std::string, FCXXCoord  >("NAVYBLUE", FCXXCoord ( 0.0, 0.0, 0.0,.501961)),
    std::pair<std::string, FCXXCoord  >("LIGHTSKYBLUE", FCXXCoord ( 0.529412, 0.807843, 0.980392)),
    std::pair<std::string, FCXXCoord  >("FORESTGREEN", FCXXCoord ( 0.133333, 0.545098, 0.133333)),
    std::pair<std::string, FCXXCoord  >("ROSY_BROWN", FCXXCoord ( 0.737255, 0.560784, 0.560784)),
    std::pair<std::string, FCXXCoord  >("BEIGE", FCXXCoord ( 0.960784, 0.960784, 0.862745)),
    std::pair<std::string, FCXXCoord  >("DEEPPINK", FCXXCoord ( 1.0, 0.0784314, 0.576471)),
    std::pair<std::string, FCXXCoord  >("MEDIUMVIOLETRED", FCXXCoord ( 0.780392, 0.0823529, 0.521569)),
    std::pair<std::string, FCXXCoord  >("DARK_ORCHID", FCXXCoord ( 0.6, 0.196078, 0.8)),
    std::pair<std::string, FCXXCoord  >("PEACHPUFF3", FCXXCoord ( 0.803922, 0.686275, 0.584314)),
    std::pair<std::string, FCXXCoord  >("BLUE4", FCXXCoord ( 0.0, 0.0, 0.0,.545098)),
    std::pair<std::string, FCXXCoord  >("DODGERBLUE4", FCXXCoord ( 0.0627451, 0.305882, 0.545098)),
    std::pair<std::string, FCXXCoord  >("LIGHTCYAN4", FCXXCoord ( 0.478431, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("PALEGREEN3", FCXXCoord ( 0.486275, 0.803922, 0.486275)),
    std::pair<std::string, FCXXCoord  >("INDIANRED3", FCXXCoord ( 0.803922, 0.333333, 0.333333)),
    std::pair<std::string, FCXXCoord  >("INDIANRED4", FCXXCoord ( 0.545098, 0.227451, 0.227451)),
    std::pair<std::string, FCXXCoord  >("SALMON3", FCXXCoord ( 0.803922, 0.439216, 0.329412)),
    std::pair<std::string, FCXXCoord  >("SALMON4", FCXXCoord ( 0.545098, 0.298039, 0.223529)),
    std::pair<std::string, FCXXCoord  >("LIGHTSALMON4", FCXXCoord ( 0.545098, 0.341176, 0.258824)),
    std::pair<std::string, FCXXCoord  >("ORANGERED2", FCXXCoord ( 0.933333, 0.25098, 0)),
    std::pair<std::string, FCXXCoord  >("PLUM3", FCXXCoord ( 0.803922, 0.588235, 0.803922)),
    std::pair<std::string, FCXXCoord  >("GRAY8", FCXXCoord ( 0.0784314, 0.0784314, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("GRAY9", FCXXCoord ( 0.0901961, 0.0901961, 0.0901961)),
    std::pair<std::string, FCXXCoord  >("GRAY11", FCXXCoord ( 0.109804, 0.109804, 0.109804)),
    std::pair<std::string, FCXXCoord  >("GRAY57", FCXXCoord ( 0.568627, 0.568627, 0.568627)),
    std::pair<std::string, FCXXCoord  >("GREY77", FCXXCoord ( 0.768627, 0.768627, 0.768627)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY8", FCXXCoord ( 0.0784314, 0.0784314, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("SGIGREY52", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_64", FCXXCoord ( 0.639216, 0.639216, 0.639216)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY68", FCXXCoord ( 0.678431, 0.678431, 0.678431)),
    std::pair<std::string, FCXXCoord  >("SGIGREY76", FCXXCoord ( 0.756863, 0.756863, 0.756863)),
    std::pair<std::string, FCXXCoord  >("FLORAL_WHITE", FCXXCoord ( 1.0, 0.980392, 0.941176)),
    std::pair<std::string, FCXXCoord  >("ANTIQUE_WHITE", FCXXCoord ( 0.980392, 0.921569, 0.843137)),
    std::pair<std::string, FCXXCoord  >("ALICEBLUE", FCXXCoord ( 0.941176, 0.972549, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHT_GRAY", FCXXCoord ( 0.827451, 0.827451, 0.827451)),
    std::pair<std::string, FCXXCoord  >("DODGERBLUE", FCXXCoord ( 0.117647, 0.564706, 1)),
    std::pair<std::string, FCXXCoord  >("MEDIUMAQUAMARINE", FCXXCoord ( 0.4, 0.803922, 0.666667)),
    std::pair<std::string, FCXXCoord  >("DARK_GREEN", FCXXCoord ( 0.0, 0.392157, 0)),
    std::pair<std::string, FCXXCoord  >("KHAKI", FCXXCoord ( 0.941176, 0.901961, 0.54902)),
    std::pair<std::string, FCXXCoord  >("LIGHTGOLDENROD", FCXXCoord ( 0.933333, 0.866667, 0.509804)),
    std::pair<std::string, FCXXCoord  >("HOT_PINK", FCXXCoord ( 1.0, 0.411765, 0.705882)),
    std::pair<std::string, FCXXCoord  >("LIGHT_PINK", FCXXCoord ( 1.0, 0.713725, 0.756863)),
    std::pair<std::string, FCXXCoord  >("ANTIQUEWHITE4", FCXXCoord ( 0.545098, 0.513725, 0.470588)),
    std::pair<std::string, FCXXCoord  >("STEELBLUE2", FCXXCoord ( 0.360784, 0.67451, 0.933333)),
    std::pair<std::string, FCXXCoord  >("TURQUOISE3", FCXXCoord ( 0.0, 0.772549, 0.803922)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEGRAY4", FCXXCoord ( 0.321569, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("AQUAMARINE1", FCXXCoord ( 0.498039, 1.0, 0.831373)),
    std::pair<std::string, FCXXCoord  >("DARKSEAGREEN2", FCXXCoord ( 0.705882, 0.933333, 0.705882)),
    std::pair<std::string, FCXXCoord  >("DARKSEAGREEN3", FCXXCoord ( 0.607843, 0.803922, 0.607843)),
    std::pair<std::string, FCXXCoord  >("SEAGREEN1", FCXXCoord ( 0.329412, 1.0, 0.623529)),
    std::pair<std::string, FCXXCoord  >("SPRINGGREEN4", FCXXCoord ( 0.0, 0.545098, 0.270588)),
    std::pair<std::string, FCXXCoord  >("LIGHTYELLOW4", FCXXCoord ( 0.545098, 0.545098, 0.478431)),
    std::pair<std::string, FCXXCoord  >("GOLD4", FCXXCoord ( 0.545098, 0.458824, 0)),
    std::pair<std::string, FCXXCoord  >("ROSYBROWN2", FCXXCoord ( 0.933333, 0.705882, 0.705882)),
    std::pair<std::string, FCXXCoord  >("INDIANRED2", FCXXCoord ( 0.933333, 0.388235, 0.388235)),
    std::pair<std::string, FCXXCoord  >("SIENNA2", FCXXCoord ( 0.933333, 0.47451, 0.258824)),
    std::pair<std::string, FCXXCoord  >("BROWN2", FCXXCoord ( 0.933333, 0.231373, 0.231373)),
    std::pair<std::string, FCXXCoord  >("DEEPPINK4", FCXXCoord ( 0.545098, 0.0392157, 0.313725)),
    std::pair<std::string, FCXXCoord  >("MAGENTA1", FCXXCoord ( 1.0, 0.0, 1)),
    std::pair<std::string, FCXXCoord  >("ORCHID1", FCXXCoord ( 1.0, 0.513725, 0.980392)),
    std::pair<std::string, FCXXCoord  >("GREY1", FCXXCoord ( 0.0117647, 0.0117647, 0.0117647)),
    std::pair<std::string, FCXXCoord  >("GREY19", FCXXCoord ( 0.188235, 0.188235, 0.188235)),
    std::pair<std::string, FCXXCoord  >("GREY42", FCXXCoord ( 0.419608, 0.419608, 0.419608)),
    std::pair<std::string, FCXXCoord  >("GREY51", FCXXCoord ( 0.509804, 0.509804, 0.509804)),
    std::pair<std::string, FCXXCoord  >("GRAY61", FCXXCoord ( 0.611765, 0.611765, 0.611765)),
    std::pair<std::string, FCXXCoord  >("GRAY85", FCXXCoord ( 0.85098, 0.85098, 0.85098)),
    std::pair<std::string, FCXXCoord  >("GREY86", FCXXCoord ( 0.858824, 0.858824, 0.858824)),
    std::pair<std::string, FCXXCoord  >("GREY87", FCXXCoord ( 0.870588, 0.870588, 0.870588)),
    std::pair<std::string, FCXXCoord  >("GRAY94", FCXXCoord ( 0.941176, 0.941176, 0.941176)),
    std::pair<std::string, FCXXCoord  >("GREY94", FCXXCoord ( 0.941176, 0.941176, 0.941176)),
    std::pair<std::string, FCXXCoord  >("GREY97", FCXXCoord ( 0.968627, 0.968627, 0.968627)),
    std::pair<std::string, FCXXCoord  >("GRAY100", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_0", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_16", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY20", FCXXCoord ( 0.2, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY48", FCXXCoord ( 0.478431, 0.478431, 0.478431)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY76", FCXXCoord ( 0.756863, 0.756863, 0.756863)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY80", FCXXCoord ( 0.8, 0.8, 0.8)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_88", FCXXCoord ( 0.878431, 0.878431, 0.878431)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY88", FCXXCoord ( 0.878431, 0.878431, 0.878431)),
    std::pair<std::string, FCXXCoord  >("SGI_DARK_GREY", FCXXCoord ( 0.333333, 0.333333, 0.333333)),
    std::pair<std::string, FCXXCoord  >("SGIBEET", FCXXCoord ( 0.556863, 0.219608, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGI_TEAL", FCXXCoord ( 0.219608, 0.556863, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGIMEDIUMGRAY", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("BISQUE", FCXXCoord ( 1.0, 0.894118, 0.768627)),
    std::pair<std::string, FCXXCoord  >("MINT_CREAM", FCXXCoord ( 0.960784, 1.0, 0.980392)),
    std::pair<std::string, FCXXCoord  >("SLATE_GREY", FCXXCoord ( 0.439216, 0.501961, 0.564706)),
    std::pair<std::string, FCXXCoord  >("LIGHTSLATEGRAY", FCXXCoord ( 0.466667, 0.533333, 0.6)),
    std::pair<std::string, FCXXCoord  >("SLATEBLUE", FCXXCoord ( 0.415686, 0.352941, 0.803922)),
    std::pair<std::string, FCXXCoord  >("POWDERBLUE", FCXXCoord ( 0.690196, 0.878431, 0.901961)),
    std::pair<std::string, FCXXCoord  >("LIGHT_SEA_GREEN", FCXXCoord ( 0.12549, 0.698039, 0.666667)),
    std::pair<std::string, FCXXCoord  >("GREENYELLOW", FCXXCoord ( 0.678431, 1.0, 0.184314)),
    std::pair<std::string, FCXXCoord  >("DARKKHAKI", FCXXCoord ( 0.741176, 0.717647, 0.419608)),
    std::pair<std::string, FCXXCoord  >("SIENNA", FCXXCoord ( 0.627451, 0.321569, 0.176471)),
    std::pair<std::string, FCXXCoord  >("SEASHELL2", FCXXCoord ( 0.933333, 0.898039, 0.870588)),
    std::pair<std::string, FCXXCoord  >("PEACHPUFF2", FCXXCoord ( 0.933333, 0.796078, 0.678431)),
    std::pair<std::string, FCXXCoord  >("LEMONCHIFFON2", FCXXCoord ( 0.933333, 0.913725, 0.74902)),
    std::pair<std::string, FCXXCoord  >("ROYALBLUE3", FCXXCoord ( 0.227451, 0.372549, 0.803922)),
    std::pair<std::string, FCXXCoord  >("LIGHTSTEELBLUE1", FCXXCoord ( 0.792157, 0.882353, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTSTEELBLUE2", FCXXCoord ( 0.737255, 0.823529, 0.933333)),
    std::pair<std::string, FCXXCoord  >("PALEGREEN2", FCXXCoord ( 0.564706, 0.933333, 0.564706)),
    std::pair<std::string, FCXXCoord  >("SPRINGGREEN1", FCXXCoord ( 0.0, 1.0, 0.498039)),
    std::pair<std::string, FCXXCoord  >("CHARTREUSE2", FCXXCoord ( 0.462745, 0.933333, 0)),
    std::pair<std::string, FCXXCoord  >("DEEPPINK2", FCXXCoord ( 0.933333, 0.0705882, 0.537255)),
    std::pair<std::string, FCXXCoord  >("MAROON4", FCXXCoord ( 0.545098, 0.109804, 0.384314)),
    std::pair<std::string, FCXXCoord  >("GREY18", FCXXCoord ( 0.180392, 0.180392, 0.180392)),
    std::pair<std::string, FCXXCoord  >("GRAY25", FCXXCoord ( 0.25098, 0.25098, 0.25098)),
    std::pair<std::string, FCXXCoord  >("GRAY43", FCXXCoord ( 0.431373, 0.431373, 0.431373)),
    std::pair<std::string, FCXXCoord  >("GRAY59", FCXXCoord ( 0.588235, 0.588235, 0.588235)),
    std::pair<std::string, FCXXCoord  >("GREY67", FCXXCoord ( 0.670588, 0.670588, 0.670588)),
    std::pair<std::string, FCXXCoord  >("GREY71", FCXXCoord ( 0.709804, 0.709804, 0.709804)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY0", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY4", FCXXCoord ( 0.0392157, 0.0392157, 0.0392157)),
    std::pair<std::string, FCXXCoord  >("SGI_VERY_DARK_GRAY", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("WHITESMOKE", FCXXCoord ( 0.960784, 0.960784, 0.960784)),
    std::pair<std::string, FCXXCoord  >("NAVAJOWHITE", FCXXCoord ( 1.0, 0.870588, 0.678431)),
    std::pair<std::string, FCXXCoord  >("ALICE_BLUE", FCXXCoord ( 0.941176, 0.972549, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTGREY", FCXXCoord ( 0.827451, 0.827451, 0.827451)),
    std::pair<std::string, FCXXCoord  >("CORNFLOWERBLUE", FCXXCoord ( 0.392157, 0.584314, 0.929412)),
    std::pair<std::string, FCXXCoord  >("LAWN_GREEN", FCXXCoord ( 0.486275, 0.988235, 0)),
    std::pair<std::string, FCXXCoord  >("OLIVEDRAB", FCXXCoord ( 0.419608, 0.556863, 0.137255)),
    std::pair<std::string, FCXXCoord  >("CHOCOLATE", FCXXCoord ( 0.823529, 0.411765, 0.117647)),
    std::pair<std::string, FCXXCoord  >("MAROON", FCXXCoord ( 0.690196, 0.188235, 0.376471)),
    std::pair<std::string, FCXXCoord  >("SNOW3", FCXXCoord ( 0.803922, 0.788235, 0.788235)),
    std::pair<std::string, FCXXCoord  >("ANTIQUEWHITE1", FCXXCoord ( 1.0, 0.937255, 0.858824)),
    std::pair<std::string, FCXXCoord  >("BISQUE1", FCXXCoord ( 1.0, 0.894118, 0.768627)),
    std::pair<std::string, FCXXCoord  >("NAVAJOWHITE1", FCXXCoord ( 1.0, 0.870588, 0.678431)),
    std::pair<std::string, FCXXCoord  >("NAVAJOWHITE2", FCXXCoord ( 0.933333, 0.811765, 0.631373)),
    std::pair<std::string, FCXXCoord  >("STEELBLUE1", FCXXCoord ( 0.388235, 0.721569, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTSKYBLUE2", FCXXCoord ( 0.643137, 0.827451, 0.933333)),
    std::pair<std::string, FCXXCoord  >("LIGHTBLUE3", FCXXCoord ( 0.603922, 0.752941, 0.803922)),
    std::pair<std::string, FCXXCoord  >("TURQUOISE2", FCXXCoord ( 0.0, 0.898039, 0.933333)),
    std::pair<std::string, FCXXCoord  >("KHAKI4", FCXXCoord ( 0.545098, 0.52549, 0.305882)),
    std::pair<std::string, FCXXCoord  >("LIGHTYELLOW3", FCXXCoord ( 0.803922, 0.803922, 0.705882)),
    std::pair<std::string, FCXXCoord  >("YELLOW1", FCXXCoord ( 1.0, 1.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("WHEAT2", FCXXCoord ( 0.933333, 0.847059, 0.682353)),
    std::pair<std::string, FCXXCoord  >("CHOCOLATE1", FCXXCoord ( 1.0, 0.498039, 0.141176)),
    std::pair<std::string, FCXXCoord  >("BROWN1", FCXXCoord ( 1.0, 0.25098, 0.25098)),
    std::pair<std::string, FCXXCoord  >("ORANGE1", FCXXCoord ( 1.0, 0.647059, 0)),
    std::pair<std::string, FCXXCoord  >("ORANGE2", FCXXCoord ( 0.933333, 0.603922, 0)),
    std::pair<std::string, FCXXCoord  >("DARKORANGE3", FCXXCoord ( 0.803922, 0.4, 0)),
    std::pair<std::string, FCXXCoord  >("LIGHTPINK4", FCXXCoord ( 0.545098, 0.372549, 0.396078)),
    std::pair<std::string, FCXXCoord  >("MAGENTA3", FCXXCoord ( 0.803922, 0.0, 0.803922)),
    std::pair<std::string, FCXXCoord  >("MAGENTA4", FCXXCoord ( 0.545098, 0.0, 0.545098)),
    std::pair<std::string, FCXXCoord  >("PURPLE2", FCXXCoord ( 0.568627, 0.172549, 0.933333)),
    std::pair<std::string, FCXXCoord  >("PURPLE3", FCXXCoord ( 0.490196, 0.14902, 0.803922)),
    std::pair<std::string, FCXXCoord  >("GREY11", FCXXCoord ( 0.109804, 0.109804, 0.109804)),
    std::pair<std::string, FCXXCoord  >("GREY15", FCXXCoord ( 0.14902, 0.14902, 0.14902)),
    std::pair<std::string, FCXXCoord  >("GRAY22", FCXXCoord ( 0.219608, 0.219608, 0.219608)),
    std::pair<std::string, FCXXCoord  >("GRAY34", FCXXCoord ( 0.341176, 0.341176, 0.341176)),
    std::pair<std::string, FCXXCoord  >("GRAY40", FCXXCoord ( 0.4, 0.4, 0.4)),
    std::pair<std::string, FCXXCoord  >("GREY41", FCXXCoord ( 0.411765, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("GREY50", FCXXCoord ( 0.498039, 0.498039, 0.498039)),
    std::pair<std::string, FCXXCoord  >("GRAY58", FCXXCoord ( 0.580392, 0.580392, 0.580392)),
    std::pair<std::string, FCXXCoord  >("GRAY80", FCXXCoord ( 0.8, 0.8, 0.8)),
    std::pair<std::string, FCXXCoord  >("GREY80", FCXXCoord ( 0.8, 0.8, 0.8)),
    std::pair<std::string, FCXXCoord  >("GREY95", FCXXCoord ( 0.94902, 0.94902, 0.94902)),
    std::pair<std::string, FCXXCoord  >("GREY96", FCXXCoord ( 0.960784, 0.960784, 0.960784)),
    std::pair<std::string, FCXXCoord  >("DARK_MAGENTA", FCXXCoord ( 0.545098, 0.0, 0.545098)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_20", FCXXCoord ( 0.2, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY44", FCXXCoord ( 0.439216, 0.439216, 0.439216)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_64", FCXXCoord ( 0.639216, 0.639216, 0.639216)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY92", FCXXCoord ( 0.917647, 0.917647, 0.917647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_96", FCXXCoord ( 0.956863, 0.956863, 0.956863)),
    std::pair<std::string, FCXXCoord  >("SGIDARKGREY", FCXXCoord ( 0.333333, 0.333333, 0.333333)),
    std::pair<std::string, FCXXCoord  >("SGI_SALMON", FCXXCoord ( 0.776471, 0.443137, 0.443137)),
    std::pair<std::string, FCXXCoord  >("LEMONCHIFFON", FCXXCoord ( 1.0, 0.980392, 0.803922)),
    std::pair<std::string, FCXXCoord  >("LAVENDER_BLUSH", FCXXCoord ( 1.0, 0.941176, 0.960784)),
    std::pair<std::string, FCXXCoord  >("MIDNIGHTBLUE", FCXXCoord ( 0.0980392, 0.0980392, 0.439216)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEBLUE", FCXXCoord ( 0.282353, 0.239216, 0.545098)),
    std::pair<std::string, FCXXCoord  >("SLATE_BLUE", FCXXCoord ( 0.415686, 0.352941, 0.803922)),
    std::pair<std::string, FCXXCoord  >("LIGHT_CYAN", FCXXCoord ( 0.878431, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("CADET_BLUE", FCXXCoord ( 0.372549, 0.619608, 0.627451)),
    std::pair<std::string, FCXXCoord  >("MEDIUMSEAGREEN", FCXXCoord ( 0.235294, 0.701961, 0.443137)),
    std::pair<std::string, FCXXCoord  >("GREEN_YELLOW", FCXXCoord ( 0.678431, 1.0, 0.184314)),
    std::pair<std::string, FCXXCoord  >("LIME_GREEN", FCXXCoord ( 0.196078, 0.803922, 0.196078)),
    std::pair<std::string, FCXXCoord  >("TAN", FCXXCoord ( 0.823529, 0.705882, 0.54902)),
    std::pair<std::string, FCXXCoord  >("DARKSALMON", FCXXCoord ( 0.913725, 0.588235, 0.478431)),
    std::pair<std::string, FCXXCoord  >("LIGHTSALMON", FCXXCoord ( 1.0, 0.627451, 0.478431)),
    std::pair<std::string, FCXXCoord  >("DARKORANGE", FCXXCoord ( 1.0, 0.54902, 0)),
    std::pair<std::string, FCXXCoord  >("LIGHT_CORAL", FCXXCoord ( 0.941176, 0.501961, 0.501961)),
    std::pair<std::string, FCXXCoord  >("ORANGE_RED", FCXXCoord ( 1.0, 0.270588, 0)),
    std::pair<std::string, FCXXCoord  >("RED", FCXXCoord ( 1.0, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("DEEP_PINK", FCXXCoord ( 1.0, 0.0784314, 0.576471)),
    std::pair<std::string, FCXXCoord  >("PALE_VIOLET_RED", FCXXCoord ( 0.858824, 0.439216, 0.576471)),
    std::pair<std::string, FCXXCoord  >("DARKVIOLET", FCXXCoord ( 0.580392, 0.0, 0.827451)),
    std::pair<std::string, FCXXCoord  >("SNOW2", FCXXCoord ( 0.933333, 0.913725, 0.913725)),
    std::pair<std::string, FCXXCoord  >("ROYALBLUE4", FCXXCoord ( 0.152941, 0.25098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("DODGERBLUE3", FCXXCoord ( 0.0941176, 0.454902, 0.803922)),
    std::pair<std::string, FCXXCoord  >("LIGHTSKYBLUE1", FCXXCoord ( 0.690196, 0.886275, 1)),
    std::pair<std::string, FCXXCoord  >("KHAKI2", FCXXCoord ( 0.933333, 0.901961, 0.521569)),
    std::pair<std::string, FCXXCoord  >("LIGHTGOLDENROD4", FCXXCoord ( 0.545098, 0.505882, 0.298039)),
    std::pair<std::string, FCXXCoord  >("SIENNA4", FCXXCoord ( 0.545098, 0.278431, 0.14902)),
    std::pair<std::string, FCXXCoord  >("LIGHTSALMON1", FCXXCoord ( 1.0, 0.627451, 0.478431)),
    std::pair<std::string, FCXXCoord  >("DARKORANGE4", FCXXCoord ( 0.545098, 0.270588, 0)),
    std::pair<std::string, FCXXCoord  >("RED3", FCXXCoord ( 0.803922, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("RED4", FCXXCoord ( 0.545098, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("PINK3", FCXXCoord ( 0.803922, 0.568627, 0.619608)),
    std::pair<std::string, FCXXCoord  >("MAGENTA2", FCXXCoord ( 0.933333, 0.0, 0.933333)),
    std::pair<std::string, FCXXCoord  >("MEDIUMORCHID2", FCXXCoord ( 0.819608, 0.372549, 0.933333)),
    std::pair<std::string, FCXXCoord  >("GRAY1", FCXXCoord ( 0.0117647, 0.0117647, 0.0117647)),
    std::pair<std::string, FCXXCoord  >("GREY7", FCXXCoord ( 0.0705882, 0.0705882, 0.0705882)),
    std::pair<std::string, FCXXCoord  >("GREY13", FCXXCoord ( 0.129412, 0.129412, 0.129412)),
    std::pair<std::string, FCXXCoord  >("GRAY31", FCXXCoord ( 0.309804, 0.309804, 0.309804)),
    std::pair<std::string, FCXXCoord  >("GREY35", FCXXCoord ( 0.34902, 0.34902, 0.34902)),
    std::pair<std::string, FCXXCoord  >("GRAY51", FCXXCoord ( 0.509804, 0.509804, 0.509804)),
    std::pair<std::string, FCXXCoord  >("GRAY55", FCXXCoord ( 0.54902, 0.54902, 0.54902)),
    std::pair<std::string, FCXXCoord  >("GREY68", FCXXCoord ( 0.678431, 0.678431, 0.678431)),
    std::pair<std::string, FCXXCoord  >("GREY69", FCXXCoord ( 0.690196, 0.690196, 0.690196)),
    std::pair<std::string, FCXXCoord  >("GREY73", FCXXCoord ( 0.729412, 0.729412, 0.729412)),
    std::pair<std::string, FCXXCoord  >("GREY74", FCXXCoord ( 0.741176, 0.741176, 0.741176)),
    std::pair<std::string, FCXXCoord  >("GREY75", FCXXCoord ( 0.74902, 0.74902, 0.74902)),
    std::pair<std::string, FCXXCoord  >("GRAY81", FCXXCoord ( 0.811765, 0.811765, 0.811765)),
    std::pair<std::string, FCXXCoord  >("GRAY90", FCXXCoord ( 0.898039, 0.898039, 0.898039)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_28", FCXXCoord ( 0.278431, 0.278431, 0.278431)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_40", FCXXCoord ( 0.4, 0.4, 0.4)),
    std::pair<std::string, FCXXCoord  >("SGI_BEET", FCXXCoord ( 0.556863, 0.219608, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGIMEDIUMGREY", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("INDIGO", FCXXCoord ( 0.294118, 0.0, 0.509804)),
    std::pair<std::string, FCXXCoord  >("OLD_LACE", FCXXCoord ( 0.992157, 0.960784, 0.901961)),
    std::pair<std::string, FCXXCoord  >("PEACH_PUFF", FCXXCoord ( 1.0, 0.854902, 0.72549)),
    std::pair<std::string, FCXXCoord  >("DARK_SLATE_GRAY", FCXXCoord ( 0.184314, 0.309804, 0.309804)),
    std::pair<std::string, FCXXCoord  >("GREY", FCXXCoord ( 0.745098, 0.745098, 0.745098)),
    std::pair<std::string, FCXXCoord  >("LIGHTGRAY", FCXXCoord ( 0.827451, 0.827451, 0.827451)),
    std::pair<std::string, FCXXCoord  >("NAVY", FCXXCoord ( 0.0, 0.0, 0.0,.501961)),
    std::pair<std::string, FCXXCoord  >("LIGHT_SLATE_BLUE", FCXXCoord ( 0.517647, 0.439216, 1)),
    std::pair<std::string, FCXXCoord  >("POWDER_BLUE", FCXXCoord ( 0.690196, 0.878431, 0.901961)),
    std::pair<std::string, FCXXCoord  >("DARK_OLIVE_GREEN", FCXXCoord ( 0.333333, 0.419608, 0.184314)),
    std::pair<std::string, FCXXCoord  >("LIGHTGOLDENRODYELLOW", FCXXCoord ( 0.980392, 0.980392, 0.823529)),
    std::pair<std::string, FCXXCoord  >("GOLD", FCXXCoord ( 1.0, 0.843137, 0)),
    std::pair<std::string, FCXXCoord  >("SADDLEBROWN", FCXXCoord ( 0.545098, 0.270588, 0.0745098)),
    std::pair<std::string, FCXXCoord  >("LIGHTPINK", FCXXCoord ( 1.0, 0.713725, 0.756863)),
    std::pair<std::string, FCXXCoord  >("ORCHID", FCXXCoord ( 0.854902, 0.439216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("BISQUE4", FCXXCoord ( 0.545098, 0.490196, 0.419608)),
    std::pair<std::string, FCXXCoord  >("CORNSILK1", FCXXCoord ( 1.0, 0.972549, 0.862745)),
    std::pair<std::string, FCXXCoord  >("HONEYDEW2", FCXXCoord ( 0.878431, 0.933333, 0.878431)),
    std::pair<std::string, FCXXCoord  >("LIGHTBLUE4", FCXXCoord ( 0.407843, 0.513725, 0.545098)),
    std::pair<std::string, FCXXCoord  >("OLIVEDRAB4", FCXXCoord ( 0.411765, 0.545098, 0.133333)),
    std::pair<std::string, FCXXCoord  >("KHAKI3", FCXXCoord ( 0.803922, 0.776471, 0.45098)),
    std::pair<std::string, FCXXCoord  >("SIENNA1", FCXXCoord ( 1.0, 0.509804, 0.278431)),
    std::pair<std::string, FCXXCoord  >("BROWN3", FCXXCoord ( 0.803922, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("RED2", FCXXCoord ( 0.933333, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("PALEVIOLETRED3", FCXXCoord ( 0.803922, 0.407843, 0.537255)),
    std::pair<std::string, FCXXCoord  >("DARKORCHID3", FCXXCoord ( 0.603922, 0.196078, 0.803922)),
    std::pair<std::string, FCXXCoord  >("DARKORCHID4", FCXXCoord ( 0.407843, 0.133333, 0.545098)),
    std::pair<std::string, FCXXCoord  >("MEDIUMPURPLE3", FCXXCoord ( 0.537255, 0.407843, 0.803922)),
    std::pair<std::string, FCXXCoord  >("MEDIUMPURPLE4", FCXXCoord ( 0.364706, 0.278431, 0.545098)),
    std::pair<std::string, FCXXCoord  >("GREY8", FCXXCoord ( 0.0784314, 0.0784314, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("GREY10", FCXXCoord ( 0.101961, 0.101961, 0.101961)),
    std::pair<std::string, FCXXCoord  >("GREY14", FCXXCoord ( 0.141176, 0.141176, 0.141176)),
    std::pair<std::string, FCXXCoord  >("GRAY20", FCXXCoord ( 0.2, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("GRAY21", FCXXCoord ( 0.211765, 0.211765, 0.211765)),
    std::pair<std::string, FCXXCoord  >("GREY26", FCXXCoord ( 0.258824, 0.258824, 0.258824)),
    std::pair<std::string, FCXXCoord  >("GREY43", FCXXCoord ( 0.431373, 0.431373, 0.431373)),
    std::pair<std::string, FCXXCoord  >("GREY52", FCXXCoord ( 0.521569, 0.521569, 0.521569)),
    std::pair<std::string, FCXXCoord  >("GRAY53", FCXXCoord ( 0.529412, 0.529412, 0.529412)),
    std::pair<std::string, FCXXCoord  >("GREY72", FCXXCoord ( 0.721569, 0.721569, 0.721569)),
    std::pair<std::string, FCXXCoord  >("GRAY75", FCXXCoord ( 0.74902, 0.74902, 0.74902)),
    std::pair<std::string, FCXXCoord  >("GREY82", FCXXCoord ( 0.819608, 0.819608, 0.819608)),
    std::pair<std::string, FCXXCoord  >("GREY83", FCXXCoord ( 0.831373, 0.831373, 0.831373)),
    std::pair<std::string, FCXXCoord  >("GREY84", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_4", FCXXCoord ( 0.0392157, 0.0392157, 0.0392157)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_12", FCXXCoord ( 0.117647, 0.117647, 0.117647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_12", FCXXCoord ( 0.117647, 0.117647, 0.117647)),
    std::pair<std::string, FCXXCoord  >("SGIGREY12", FCXXCoord ( 0.117647, 0.117647, 0.117647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_20", FCXXCoord ( 0.2, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("SGIGREY24", FCXXCoord ( 0.239216, 0.239216, 0.239216)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_36", FCXXCoord ( 0.356863, 0.356863, 0.356863)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_56", FCXXCoord ( 0.556863, 0.556863, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_56", FCXXCoord ( 0.556863, 0.556863, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_92", FCXXCoord ( 0.917647, 0.917647, 0.917647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_100", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("BLANCHED_ALMOND", FCXXCoord ( 1.0, 0.921569, 0.803922)),
    std::pair<std::string, FCXXCoord  >("PEACHPUFF", FCXXCoord ( 1.0, 0.854902, 0.72549)),
    std::pair<std::string, FCXXCoord  >("MOCCASIN", FCXXCoord ( 1.0, 0.894118, 0.709804)),
    std::pair<std::string, FCXXCoord  >("MINTCREAM", FCXXCoord ( 0.960784, 1.0, 0.980392)),
    std::pair<std::string, FCXXCoord  >("LAVENDERBLUSH", FCXXCoord ( 1.0, 0.941176, 0.960784)),
    std::pair<std::string, FCXXCoord  >("LIGHT_SLATE_GRAY", FCXXCoord ( 0.466667, 0.533333, 0.6)),
    std::pair<std::string, FCXXCoord  >("GRAY", FCXXCoord ( 0.745098, 0.745098, 0.745098)),
    std::pair<std::string, FCXXCoord  >("CORNFLOWER_BLUE", FCXXCoord ( 0.392157, 0.584314, 0.929412)),
    std::pair<std::string, FCXXCoord  >("DARKOLIVEGREEN", FCXXCoord ( 0.333333, 0.419608, 0.184314)),
    std::pair<std::string, FCXXCoord  >("PALEGREEN", FCXXCoord ( 0.596078, 0.984314, 0.596078)),
    std::pair<std::string, FCXXCoord  >("CHARTREUSE", FCXXCoord ( 0.498039, 1.0, 0)),
    std::pair<std::string, FCXXCoord  >("SALMON", FCXXCoord ( 0.980392, 0.501961, 0.447059)),
    std::pair<std::string, FCXXCoord  >("LIGHTCORAL", FCXXCoord ( 0.941176, 0.501961, 0.501961)),
    std::pair<std::string, FCXXCoord  >("PINK", FCXXCoord ( 1.0, 0.752941, 0.796078)),
    std::pair<std::string, FCXXCoord  >("VIOLET_RED", FCXXCoord ( 0.815686, 0.12549, 0.564706)),
    std::pair<std::string, FCXXCoord  >("LAVENDERBLUSH1", FCXXCoord ( 1.0, 0.941176, 0.960784)),
    std::pair<std::string, FCXXCoord  >("LAVENDERBLUSH2", FCXXCoord ( 0.933333, 0.878431, 0.898039)),
    std::pair<std::string, FCXXCoord  >("LAVENDERBLUSH3", FCXXCoord ( 0.803922, 0.756863, 0.772549)),
    std::pair<std::string, FCXXCoord  >("MISTYROSE1", FCXXCoord ( 1.0, 0.894118, 0.882353)),
    std::pair<std::string, FCXXCoord  >("MISTYROSE4", FCXXCoord ( 0.545098, 0.490196, 0.482353)),
    std::pair<std::string, FCXXCoord  >("AZURE4", FCXXCoord ( 0.513725, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("SKYBLUE2", FCXXCoord ( 0.494118, 0.752941, 0.933333)),
    std::pair<std::string, FCXXCoord  >("LIGHTCYAN3", FCXXCoord ( 0.705882, 0.803922, 0.803922)),
    std::pair<std::string, FCXXCoord  >("AQUAMARINE2", FCXXCoord ( 0.462745, 0.933333, 0.776471)),
    std::pair<std::string, FCXXCoord  >("OLIVEDRAB2", FCXXCoord ( 0.701961, 0.933333, 0.227451)),
    std::pair<std::string, FCXXCoord  >("DARKOLIVEGREEN1", FCXXCoord ( 0.792157, 1.0, 0.439216)),
    std::pair<std::string, FCXXCoord  >("TAN3", FCXXCoord ( 0.803922, 0.521569, 0.247059)),
    std::pair<std::string, FCXXCoord  >("TOMATO1", FCXXCoord ( 1.0, 0.388235, 0.278431)),
    std::pair<std::string, FCXXCoord  >("MAROON3", FCXXCoord ( 0.803922, 0.160784, 0.564706)),
    std::pair<std::string, FCXXCoord  >("ORCHID3", FCXXCoord ( 0.803922, 0.411765, 0.788235)),
    std::pair<std::string, FCXXCoord  >("GREY3", FCXXCoord ( 0.0313725, 0.0313725, 0.0313725)),
    std::pair<std::string, FCXXCoord  >("GRAY15", FCXXCoord ( 0.14902, 0.14902, 0.14902)),
    std::pair<std::string, FCXXCoord  >("GRAY19", FCXXCoord ( 0.188235, 0.188235, 0.188235)),
    std::pair<std::string, FCXXCoord  >("GRAY30", FCXXCoord ( 0.301961, 0.301961, 0.301961)),
    std::pair<std::string, FCXXCoord  >("GREY37", FCXXCoord ( 0.368627, 0.368627, 0.368627)),
    std::pair<std::string, FCXXCoord  >("GREY38", FCXXCoord ( 0.380392, 0.380392, 0.380392)),
    std::pair<std::string, FCXXCoord  >("GREY39", FCXXCoord ( 0.388235, 0.388235, 0.388235)),
    std::pair<std::string, FCXXCoord  >("GRAY50", FCXXCoord ( 0.498039, 0.498039, 0.498039)),
    std::pair<std::string, FCXXCoord  >("GRAY54", FCXXCoord ( 0.541176, 0.541176, 0.541176)),
    std::pair<std::string, FCXXCoord  >("GREY62", FCXXCoord ( 0.619608, 0.619608, 0.619608)),
    std::pair<std::string, FCXXCoord  >("GRAY66", FCXXCoord ( 0.658824, 0.658824, 0.658824)),
    std::pair<std::string, FCXXCoord  >("GREY81", FCXXCoord ( 0.811765, 0.811765, 0.811765)),
    std::pair<std::string, FCXXCoord  >("GRAY83", FCXXCoord ( 0.831373, 0.831373, 0.831373)),
    std::pair<std::string, FCXXCoord  >("GRAY92", FCXXCoord ( 0.921569, 0.921569, 0.921569)),
    std::pair<std::string, FCXXCoord  >("SGIGREY16", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_28", FCXXCoord ( 0.278431, 0.278431, 0.278431)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY40", FCXXCoord ( 0.4, 0.4, 0.4)),
    std::pair<std::string, FCXXCoord  >("SGIGREY56", FCXXCoord ( 0.556863, 0.556863, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_72", FCXXCoord ( 0.717647, 0.717647, 0.717647)),
    std::pair<std::string, FCXXCoord  >("INDIGO2", FCXXCoord ( 0.129412, 0.533333, 0.407843)),
    std::pair<std::string, FCXXCoord  >("ANTIQUEWHITE", FCXXCoord ( 0.980392, 0.921569, 0.843137)),
    std::pair<std::string, FCXXCoord  >("MIDNIGHT_BLUE", FCXXCoord ( 0.0980392, 0.0980392, 0.439216)),
    std::pair<std::string, FCXXCoord  >("SKY_BLUE", FCXXCoord ( 0.529412, 0.807843, 0.921569)),
    std::pair<std::string, FCXXCoord  >("LIGHT_SKY_BLUE", FCXXCoord ( 0.529412, 0.807843, 0.980392)),
    std::pair<std::string, FCXXCoord  >("STEEL_BLUE", FCXXCoord ( 0.27451, 0.509804, 0.705882)),
    std::pair<std::string, FCXXCoord  >("DARKSEAGREEN", FCXXCoord ( 0.560784, 0.737255, 0.560784)),
    std::pair<std::string, FCXXCoord  >("YELLOW_GREEN", FCXXCoord ( 0.603922, 0.803922, 0.196078)),
    std::pair<std::string, FCXXCoord  >("PALEGOLDENROD", FCXXCoord ( 0.933333, 0.909804, 0.666667)),
    std::pair<std::string, FCXXCoord  >("ORANGERED", FCXXCoord ( 1.0, 0.270588, 0)),
    std::pair<std::string, FCXXCoord  >("LIGHTSTEELBLUE4", FCXXCoord ( 0.431373, 0.482353, 0.545098)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEGRAY1", FCXXCoord ( 0.592157, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEGRAY2", FCXXCoord ( 0.552941, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEGRAY3", FCXXCoord ( 0.47451, 0.803922, 0.803922)),
    std::pair<std::string, FCXXCoord  >("CHARTREUSE4", FCXXCoord ( 0.270588, 0.545098, 0)),
    std::pair<std::string, FCXXCoord  >("OLIVEDRAB3", FCXXCoord ( 0.603922, 0.803922, 0.196078)),
    std::pair<std::string, FCXXCoord  >("DARKOLIVEGREEN4", FCXXCoord ( 0.431373, 0.545098, 0.239216)),
    std::pair<std::string, FCXXCoord  >("CORAL1", FCXXCoord ( 1.0, 0.447059, 0.337255)),
    std::pair<std::string, FCXXCoord  >("CORAL4", FCXXCoord ( 0.545098, 0.243137, 0.184314)),
    std::pair<std::string, FCXXCoord  >("LIGHTPINK2", FCXXCoord ( 0.933333, 0.635294, 0.678431)),
    std::pair<std::string, FCXXCoord  >("PALEVIOLETRED4", FCXXCoord ( 0.545098, 0.278431, 0.364706)),
    std::pair<std::string, FCXXCoord  >("ORCHID2", FCXXCoord ( 0.933333, 0.478431, 0.913725)),
    std::pair<std::string, FCXXCoord  >("PLUM1", FCXXCoord ( 1.0, 0.733333, 1)),
    std::pair<std::string, FCXXCoord  >("THISTLE4", FCXXCoord ( 0.545098, 0.482353, 0.545098)),
    std::pair<std::string, FCXXCoord  >("GREY9", FCXXCoord ( 0.0901961, 0.0901961, 0.0901961)),
    std::pair<std::string, FCXXCoord  >("GREY28", FCXXCoord ( 0.278431, 0.278431, 0.278431)),
    std::pair<std::string, FCXXCoord  >("GREY29", FCXXCoord ( 0.290196, 0.290196, 0.290196)),
    std::pair<std::string, FCXXCoord  >("GREY36", FCXXCoord ( 0.360784, 0.360784, 0.360784)),
    std::pair<std::string, FCXXCoord  >("GRAY77", FCXXCoord ( 0.768627, 0.768627, 0.768627)),
    std::pair<std::string, FCXXCoord  >("GRAY78", FCXXCoord ( 0.780392, 0.780392, 0.780392)),
    std::pair<std::string, FCXXCoord  >("GRAY79", FCXXCoord ( 0.788235, 0.788235, 0.788235)),
    std::pair<std::string, FCXXCoord  >("SGIGREY60", FCXXCoord ( 0.6, 0.6, 0.6)),
    std::pair<std::string, FCXXCoord  >("DARK_SLATE_BLUE", FCXXCoord ( 0.282353, 0.239216, 0.545098)),
    std::pair<std::string, FCXXCoord  >("ROYALBLUE", FCXXCoord ( 0.254902, 0.411765, 0.882353)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_TURQUOISE", FCXXCoord ( 0.282353, 0.819608, 0.8)),
    std::pair<std::string, FCXXCoord  >("CADETBLUE", FCXXCoord ( 0.372549, 0.619608, 0.627451)),
    std::pair<std::string, FCXXCoord  >("SPRINGGREEN", FCXXCoord ( 0.0, 1.0, 0.498039)),
    std::pair<std::string, FCXXCoord  >("INDIAN_RED", FCXXCoord ( 0.803922, 0.360784, 0.360784)),
    std::pair<std::string, FCXXCoord  >("HOTPINK", FCXXCoord ( 1.0, 0.411765, 0.705882)),
    std::pair<std::string, FCXXCoord  >("MEDIUMORCHID", FCXXCoord ( 0.729412, 0.333333, 0.827451)),
    std::pair<std::string, FCXXCoord  >("ANTIQUEWHITE3", FCXXCoord ( 0.803922, 0.752941, 0.690196)),
    std::pair<std::string, FCXXCoord  >("LEMONCHIFFON4", FCXXCoord ( 0.545098, 0.537255, 0.439216)),
    std::pair<std::string, FCXXCoord  >("MISTYROSE2", FCXXCoord ( 0.933333, 0.835294, 0.823529)),
    std::pair<std::string, FCXXCoord  >("BLUE2", FCXXCoord ( 0.0, 0.0, 0.0,.933333)),
    std::pair<std::string, FCXXCoord  >("STEELBLUE3", FCXXCoord ( 0.309804, 0.580392, 0.803922)),
    std::pair<std::string, FCXXCoord  >("SKYBLUE3", FCXXCoord ( 0.423529, 0.65098, 0.803922)),
    std::pair<std::string, FCXXCoord  >("LIGHTCYAN2", FCXXCoord ( 0.819608, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("TURQUOISE4", FCXXCoord ( 0.0, 0.52549, 0.545098)),
    std::pair<std::string, FCXXCoord  >("DARKSEAGREEN1", FCXXCoord ( 0.756863, 1.0, 0.756863)),
    std::pair<std::string, FCXXCoord  >("YELLOW3", FCXXCoord ( 0.803922, 0.803922, 0)),
    std::pair<std::string, FCXXCoord  >("GOLD1", FCXXCoord ( 1.0, 0.843137, 0)),
    std::pair<std::string, FCXXCoord  >("GOLD3", FCXXCoord ( 0.803922, 0.678431, 0)),
    std::pair<std::string, FCXXCoord  >("TAN2", FCXXCoord ( 0.933333, 0.603922, 0.286275)),
    std::pair<std::string, FCXXCoord  >("FIREBRICK2", FCXXCoord ( 0.933333, 0.172549, 0.172549)),
    std::pair<std::string, FCXXCoord  >("SALMON1", FCXXCoord ( 1.0, 0.54902, 0.411765)),
    std::pair<std::string, FCXXCoord  >("ORANGE4", FCXXCoord ( 0.545098, 0.352941, 0)),
    std::pair<std::string, FCXXCoord  >("PLUM4", FCXXCoord ( 0.545098, 0.4, 0.545098)),
    std::pair<std::string, FCXXCoord  >("GRAY6", FCXXCoord ( 0.0588235, 0.0588235, 0.0588235)),
    std::pair<std::string, FCXXCoord  >("GREY6", FCXXCoord ( 0.0588235, 0.0588235, 0.0588235)),
    std::pair<std::string, FCXXCoord  >("GRAY14", FCXXCoord ( 0.141176, 0.141176, 0.141176)),
    std::pair<std::string, FCXXCoord  >("GRAY18", FCXXCoord ( 0.180392, 0.180392, 0.180392)),
    std::pair<std::string, FCXXCoord  >("GRAY39", FCXXCoord ( 0.388235, 0.388235, 0.388235)),
    std::pair<std::string, FCXXCoord  >("GRAY56", FCXXCoord ( 0.560784, 0.560784, 0.560784)),
    std::pair<std::string, FCXXCoord  >("GREY90", FCXXCoord ( 0.898039, 0.898039, 0.898039)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_40", FCXXCoord ( 0.4, 0.4, 0.4)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY64", FCXXCoord ( 0.639216, 0.639216, 0.639216)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_80", FCXXCoord ( 0.8, 0.8, 0.8)),
    std::pair<std::string, FCXXCoord  >("SGIGREY80", FCXXCoord ( 0.8, 0.8, 0.8)),
    std::pair<std::string, FCXXCoord  >("SGI_SLATE_BLUE", FCXXCoord ( 0.443137, 0.443137, 0.776471)),
    std::pair<std::string, FCXXCoord  >("SGIVERYDARKGRAY", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SGIBRIGHTGRAY", FCXXCoord ( 0.772549, 0.756863, 0.666667)),
    std::pair<std::string, FCXXCoord  >("IVORY", FCXXCoord ( 1.0, 1.0, 0.0,.941176)),
    std::pair<std::string, FCXXCoord  >("DARK_SALMON", FCXXCoord ( 0.913725, 0.588235, 0.478431)),
    std::pair<std::string, FCXXCoord  >("DARK_VIOLET", FCXXCoord ( 0.580392, 0.0, 0.827451)),
    std::pair<std::string, FCXXCoord  >("LIGHTBLUE1", FCXXCoord ( 0.74902, 0.937255, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTBLUE2", FCXXCoord ( 0.698039, 0.87451, 0.933333)),
    std::pair<std::string, FCXXCoord  >("TURQUOISE1", FCXXCoord ( 0.0, 0.960784, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTYELLOW2", FCXXCoord ( 0.933333, 0.933333, 0.819608)),
    std::pair<std::string, FCXXCoord  >("YELLOW4", FCXXCoord ( 0.545098, 0.545098, 0)),
    std::pair<std::string, FCXXCoord  >("CORAL3", FCXXCoord ( 0.803922, 0.356863, 0.270588)),
    std::pair<std::string, FCXXCoord  >("DEEPPINK3", FCXXCoord ( 0.803922, 0.0627451, 0.462745)),
    std::pair<std::string, FCXXCoord  >("HOTPINK1", FCXXCoord ( 1.0, 0.431373, 0.705882)),
    std::pair<std::string, FCXXCoord  >("LIGHTPINK1", FCXXCoord ( 1.0, 0.682353, 0.72549)),
    std::pair<std::string, FCXXCoord  >("MEDIUMORCHID4", FCXXCoord ( 0.478431, 0.215686, 0.545098)),
    std::pair<std::string, FCXXCoord  >("GRAY2", FCXXCoord ( 0.0196078, 0.0196078, 0.0196078)),
    std::pair<std::string, FCXXCoord  >("GRAY4", FCXXCoord ( 0.0392157, 0.0392157, 0.0392157)),
    std::pair<std::string, FCXXCoord  >("GREY20", FCXXCoord ( 0.2, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("GREY24", FCXXCoord ( 0.239216, 0.239216, 0.239216)),
    std::pair<std::string, FCXXCoord  >("GREY31", FCXXCoord ( 0.309804, 0.309804, 0.309804)),
    std::pair<std::string, FCXXCoord  >("GREY49", FCXXCoord ( 0.490196, 0.490196, 0.490196)),
    std::pair<std::string, FCXXCoord  >("GREY58", FCXXCoord ( 0.580392, 0.580392, 0.580392)),
    std::pair<std::string, FCXXCoord  >("GREY63", FCXXCoord ( 0.631373, 0.631373, 0.631373)),
    std::pair<std::string, FCXXCoord  >("GRAY67", FCXXCoord ( 0.670588, 0.670588, 0.670588)),
    std::pair<std::string, FCXXCoord  >("GRAY73", FCXXCoord ( 0.729412, 0.729412, 0.729412)),
    std::pair<std::string, FCXXCoord  >("GREY89", FCXXCoord ( 0.890196, 0.890196, 0.890196)),
    std::pair<std::string, FCXXCoord  >("DARK_CYAN", FCXXCoord ( 0.0, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("DARKCYAN", FCXXCoord ( 0.0, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY56", FCXXCoord ( 0.556863, 0.556863, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_76", FCXXCoord ( 0.756863, 0.756863, 0.756863)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY96", FCXXCoord ( 0.956863, 0.956863, 0.956863)),
    std::pair<std::string, FCXXCoord  >("SGI_MEDIUM_GRAY", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("GHOSTWHITE", FCXXCoord ( 0.972549, 0.972549, 1)),
    std::pair<std::string, FCXXCoord  >("DIMGREY", FCXXCoord ( 0.411765, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("SLATEGRAY", FCXXCoord ( 0.439216, 0.501961, 0.564706)),
    std::pair<std::string, FCXXCoord  >("LIGHTSLATEBLUE", FCXXCoord ( 0.517647, 0.439216, 1)),
    std::pair<std::string, FCXXCoord  >("ROYAL_BLUE", FCXXCoord ( 0.254902, 0.411765, 0.882353)),
    std::pair<std::string, FCXXCoord  >("PALE_GREEN", FCXXCoord ( 0.596078, 0.984314, 0.596078)),
    std::pair<std::string, FCXXCoord  >("FOREST_GREEN", FCXXCoord ( 0.133333, 0.545098, 0.133333)),
    std::pair<std::string, FCXXCoord  >("SEASHELL3", FCXXCoord ( 0.803922, 0.772549, 0.74902)),
    std::pair<std::string, FCXXCoord  >("PEACHPUFF4", FCXXCoord ( 0.545098, 0.466667, 0.396078)),
    std::pair<std::string, FCXXCoord  >("CORNSILK2", FCXXCoord ( 0.933333, 0.909804, 0.803922)),
    std::pair<std::string, FCXXCoord  >("CORNSILK4", FCXXCoord ( 0.545098, 0.533333, 0.470588)),
    std::pair<std::string, FCXXCoord  >("IVORY3", FCXXCoord ( 0.803922, 0.803922, 0.756863)),
    std::pair<std::string, FCXXCoord  >("HONEYDEW3", FCXXCoord ( 0.756863, 0.803922, 0.756863)),
    std::pair<std::string, FCXXCoord  >("AZURE2", FCXXCoord ( 0.878431, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("SLATEGRAY2", FCXXCoord ( 0.72549, 0.827451, 0.933333)),
    std::pair<std::string, FCXXCoord  >("SLATEGRAY3", FCXXCoord ( 0.623529, 0.713725, 0.803922)),
    std::pair<std::string, FCXXCoord  >("SLATEGRAY4", FCXXCoord ( 0.423529, 0.482353, 0.545098)),
    std::pair<std::string, FCXXCoord  >("CADETBLUE3", FCXXCoord ( 0.478431, 0.772549, 0.803922)),
    std::pair<std::string, FCXXCoord  >("DARKSEAGREEN4", FCXXCoord ( 0.411765, 0.545098, 0.411765)),
    std::pair<std::string, FCXXCoord  >("PALEGREEN4", FCXXCoord ( 0.329412, 0.545098, 0.329412)),
    std::pair<std::string, FCXXCoord  >("SPRINGGREEN3", FCXXCoord ( 0.0, 0.803922, 0.4)),
    std::pair<std::string, FCXXCoord  >("KHAKI1", FCXXCoord ( 1.0, 0.964706, 0.560784)),
    std::pair<std::string, FCXXCoord  >("LIGHTGOLDENROD2", FCXXCoord ( 0.933333, 0.862745, 0.509804)),
    std::pair<std::string, FCXXCoord  >("GOLDENROD1", FCXXCoord ( 1.0, 0.756863, 0.145098)),
    std::pair<std::string, FCXXCoord  >("FIREBRICK3", FCXXCoord ( 0.803922, 0.14902, 0.14902)),
    std::pair<std::string, FCXXCoord  >("FIREBRICK4", FCXXCoord ( 0.545098, 0.101961, 0.101961)),
    std::pair<std::string, FCXXCoord  >("ORANGERED3", FCXXCoord ( 0.803922, 0.215686, 0)),
    std::pair<std::string, FCXXCoord  >("MEDIUMORCHID3", FCXXCoord ( 0.705882, 0.321569, 0.803922)),
    std::pair<std::string, FCXXCoord  >("PURPLE1", FCXXCoord ( 0.607843, 0.188235, 1)),
    std::pair<std::string, FCXXCoord  >("GRAY3", FCXXCoord ( 0.0313725, 0.0313725, 0.0313725)),
    std::pair<std::string, FCXXCoord  >("GREY12", FCXXCoord ( 0.121569, 0.121569, 0.121569)),
    std::pair<std::string, FCXXCoord  >("GREY22", FCXXCoord ( 0.219608, 0.219608, 0.219608)),
    std::pair<std::string, FCXXCoord  >("GREY32", FCXXCoord ( 0.321569, 0.321569, 0.321569)),
    std::pair<std::string, FCXXCoord  >("GRAY49", FCXXCoord ( 0.490196, 0.490196, 0.490196)),
    std::pair<std::string, FCXXCoord  >("GRAY60", FCXXCoord ( 0.6, 0.6, 0.6)),
    std::pair<std::string, FCXXCoord  >("GREY60", FCXXCoord ( 0.6, 0.6, 0.6)),
    std::pair<std::string, FCXXCoord  >("GRAY64", FCXXCoord ( 0.639216, 0.639216, 0.639216)),
    std::pair<std::string, FCXXCoord  >("GREY70", FCXXCoord ( 0.701961, 0.701961, 0.701961)),
    std::pair<std::string, FCXXCoord  >("GRAY71", FCXXCoord ( 0.709804, 0.709804, 0.709804)),
    std::pair<std::string, FCXXCoord  >("GRAY89", FCXXCoord ( 0.890196, 0.890196, 0.890196)),
    std::pair<std::string, FCXXCoord  >("GRAY98", FCXXCoord ( 0.980392, 0.980392, 0.980392)),
    std::pair<std::string, FCXXCoord  >("DARKRED", FCXXCoord ( 0.545098, 0.0, 0)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_32", FCXXCoord ( 0.317647, 0.317647, 0.317647)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY60", FCXXCoord ( 0.6, 0.6, 0.6)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_68", FCXXCoord ( 0.678431, 0.678431, 0.678431)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_68", FCXXCoord ( 0.678431, 0.678431, 0.678431)),
    std::pair<std::string, FCXXCoord  >("SGIGREY84", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("SGITEAL", FCXXCoord ( 0.219608, 0.556863, 0.556863)),
    std::pair<std::string, FCXXCoord  >("SGI_LIGHT_GREY", FCXXCoord ( 0.666667, 0.666667, 0.666667)),
    std::pair<std::string, FCXXCoord  >("SGIVERYLIGHTGREY", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("NAVAJO_WHITE", FCXXCoord ( 1.0, 0.870588, 0.678431)),
    std::pair<std::string, FCXXCoord  >("WHITE", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("BLACK", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("PALETURQUOISE2", FCXXCoord ( 0.682353, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("CADETBLUE1", FCXXCoord ( 0.596078, 0.960784, 1)),
    std::pair<std::string, FCXXCoord  >("CYAN3", FCXXCoord ( 0.0, 0.803922, 0.803922)),
    std::pair<std::string, FCXXCoord  >("AQUAMARINE3", FCXXCoord ( 0.4, 0.803922, 0.666667)),
    std::pair<std::string, FCXXCoord  >("GREEN2", FCXXCoord ( 0.0, 0.933333, 0)),
    std::pair<std::string, FCXXCoord  >("LIGHTYELLOW1", FCXXCoord ( 1.0, 1.0, 0.0,.878431)),
    std::pair<std::string, FCXXCoord  >("BURLYWOOD3", FCXXCoord ( 0.803922, 0.666667, 0.490196)),
    std::pair<std::string, FCXXCoord  >("WHEAT3", FCXXCoord ( 0.803922, 0.729412, 0.588235)),
    std::pair<std::string, FCXXCoord  >("TOMATO2", FCXXCoord ( 0.933333, 0.360784, 0.258824)),
    std::pair<std::string, FCXXCoord  >("TOMATO4", FCXXCoord ( 0.545098, 0.211765, 0.14902)),
    std::pair<std::string, FCXXCoord  >("LIGHTPINK3", FCXXCoord ( 0.803922, 0.54902, 0.584314)),
    std::pair<std::string, FCXXCoord  >("PALEVIOLETRED1", FCXXCoord ( 1.0, 0.509804, 0.670588)),
    std::pair<std::string, FCXXCoord  >("PALEVIOLETRED2", FCXXCoord ( 0.933333, 0.47451, 0.623529)),
    std::pair<std::string, FCXXCoord  >("GREY23", FCXXCoord ( 0.231373, 0.231373, 0.231373)),
    std::pair<std::string, FCXXCoord  >("GRAY52", FCXXCoord ( 0.521569, 0.521569, 0.521569)),
    std::pair<std::string, FCXXCoord  >("GRAY62", FCXXCoord ( 0.619608, 0.619608, 0.619608)),
    std::pair<std::string, FCXXCoord  >("GRAY72", FCXXCoord ( 0.721569, 0.721569, 0.721569)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_24", FCXXCoord ( 0.239216, 0.239216, 0.239216)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_76", FCXXCoord ( 0.756863, 0.756863, 0.756863)),
    std::pair<std::string, FCXXCoord  >("SGI_LIGHT_BLUE", FCXXCoord ( 0.490196, 0.619608, 0.752941)),
    std::pair<std::string, FCXXCoord  >("SGI_LIGHT_GRAY", FCXXCoord ( 0.666667, 0.666667, 0.666667)),
    std::pair<std::string, FCXXCoord  >("SGILIGHTGRAY", FCXXCoord ( 0.666667, 0.666667, 0.666667)),
    std::pair<std::string, FCXXCoord  >("SGIVERYLIGHTGRAY", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("SGI_MEDIUM_GREY", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("SGIVERYDARKGREY", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SGIBRIGHTGREY", FCXXCoord ( 0.772549, 0.756863, 0.666667)),
    std::pair<std::string, FCXXCoord  >("DEEPSKYBLUE", FCXXCoord ( 0.0, 0.74902, 1)),
    std::pair<std::string, FCXXCoord  >("SADDLE_BROWN", FCXXCoord ( 0.545098, 0.270588, 0.0745098)),
    std::pair<std::string, FCXXCoord  >("FIREBRICK", FCXXCoord ( 0.698039, 0.133333, 0.133333)),
    std::pair<std::string, FCXXCoord  >("SNOW1", FCXXCoord ( 1.0, 0.980392, 0.980392)),
    std::pair<std::string, FCXXCoord  >("AZURE3", FCXXCoord ( 0.756863, 0.803922, 0.803922)),
    std::pair<std::string, FCXXCoord  >("SLATEBLUE2", FCXXCoord ( 0.478431, 0.403922, 0.933333)),
    std::pair<std::string, FCXXCoord  >("DARKGOLDENROD2", FCXXCoord ( 0.933333, 0.678431, 0.054902)),
    std::pair<std::string, FCXXCoord  >("DARKGOLDENROD3", FCXXCoord ( 0.803922, 0.584314, 0.0470588)),
    std::pair<std::string, FCXXCoord  >("DARKGOLDENROD4", FCXXCoord ( 0.545098, 0.396078, 0.0313725)),
    std::pair<std::string, FCXXCoord  >("TAN1", FCXXCoord ( 1.0, 0.647059, 0.309804)),
    std::pair<std::string, FCXXCoord  >("VIOLETRED1", FCXXCoord ( 1.0, 0.243137, 0.588235)),
    std::pair<std::string, FCXXCoord  >("VIOLETRED2", FCXXCoord ( 0.933333, 0.227451, 0.54902)),
    std::pair<std::string, FCXXCoord  >("VIOLETRED3", FCXXCoord ( 0.803922, 0.196078, 0.470588)),
    std::pair<std::string, FCXXCoord  >("GRAY10", FCXXCoord ( 0.101961, 0.101961, 0.101961)),
    std::pair<std::string, FCXXCoord  >("GRAY13", FCXXCoord ( 0.129412, 0.129412, 0.129412)),
    std::pair<std::string, FCXXCoord  >("GRAY32", FCXXCoord ( 0.321569, 0.321569, 0.321569)),
    std::pair<std::string, FCXXCoord  >("GRAY36", FCXXCoord ( 0.360784, 0.360784, 0.360784)),
    std::pair<std::string, FCXXCoord  >("GREY76", FCXXCoord ( 0.760784, 0.760784, 0.760784)),
    std::pair<std::string, FCXXCoord  >("GREY79", FCXXCoord ( 0.788235, 0.788235, 0.788235)),
    std::pair<std::string, FCXXCoord  >("GRAY84", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("GRAY93", FCXXCoord ( 0.929412, 0.929412, 0.929412)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY36", FCXXCoord ( 0.356863, 0.356863, 0.356863)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_44", FCXXCoord ( 0.439216, 0.439216, 0.439216)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_44", FCXXCoord ( 0.439216, 0.439216, 0.439216)),
    std::pair<std::string, FCXXCoord  >("SGIGREY48", FCXXCoord ( 0.478431, 0.478431, 0.478431)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_72", FCXXCoord ( 0.717647, 0.717647, 0.717647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_80", FCXXCoord ( 0.8, 0.8, 0.8)),
    std::pair<std::string, FCXXCoord  >("SGI_DARK_GRAY", FCXXCoord ( 0.333333, 0.333333, 0.333333)),
    std::pair<std::string, FCXXCoord  >("SGI_OLIVE_DRAB", FCXXCoord ( 0.556863, 0.556863, 0.219608)),
    std::pair<std::string, FCXXCoord  >("SGI_BRIGHT_GREY", FCXXCoord ( 0.772549, 0.756863, 0.666667)),
    std::pair<std::string, FCXXCoord  >("OLDLACE", FCXXCoord ( 0.992157, 0.960784, 0.901961)),
    std::pair<std::string, FCXXCoord  >("LINEN", FCXXCoord ( 0.980392, 0.941176, 0.901961)),
    std::pair<std::string, FCXXCoord  >("LAVENDER", FCXXCoord ( 0.901961, 0.901961, 0.980392)),
    std::pair<std::string, FCXXCoord  >("MISTY_ROSE", FCXXCoord ( 1.0, 0.894118, 0.882353)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEGREY", FCXXCoord ( 0.184314, 0.309804, 0.309804)),
    std::pair<std::string, FCXXCoord  >("DARK_TURQUOISE", FCXXCoord ( 0.0, 0.807843, 0.819608)),
    std::pair<std::string, FCXXCoord  >("DARKTURQUOISE", FCXXCoord ( 0.0, 0.807843, 0.819608)),
    std::pair<std::string, FCXXCoord  >("LIGHT_GOLDENROD_YELLOW", FCXXCoord ( 0.980392, 0.980392, 0.823529)),
    std::pair<std::string, FCXXCoord  >("INDIANRED", FCXXCoord ( 0.803922, 0.360784, 0.360784)),
    std::pair<std::string, FCXXCoord  >("LAVENDERBLUSH4", FCXXCoord ( 0.545098, 0.513725, 0.52549)),
    std::pair<std::string, FCXXCoord  >("SEAGREEN2", FCXXCoord ( 0.305882, 0.933333, 0.580392)),
    std::pair<std::string, FCXXCoord  >("ROSYBROWN4", FCXXCoord ( 0.545098, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("LIGHTSALMON3", FCXXCoord ( 0.803922, 0.505882, 0.384314)),
    std::pair<std::string, FCXXCoord  >("DEEPPINK1", FCXXCoord ( 1.0, 0.0784314, 0.576471)),
    std::pair<std::string, FCXXCoord  >("GRAY12", FCXXCoord ( 0.121569, 0.121569, 0.121569)),
    std::pair<std::string, FCXXCoord  >("GREY21", FCXXCoord ( 0.211765, 0.211765, 0.211765)),
    std::pair<std::string, FCXXCoord  >("GRAY38", FCXXCoord ( 0.380392, 0.380392, 0.380392)),
    std::pair<std::string, FCXXCoord  >("GREY45", FCXXCoord ( 0.45098, 0.45098, 0.45098)),
    std::pair<std::string, FCXXCoord  >("GREY54", FCXXCoord ( 0.541176, 0.541176, 0.541176)),
    std::pair<std::string, FCXXCoord  >("GRAY70", FCXXCoord ( 0.701961, 0.701961, 0.701961)),
    std::pair<std::string, FCXXCoord  >("GREY78", FCXXCoord ( 0.780392, 0.780392, 0.780392)),
    std::pair<std::string, FCXXCoord  >("GRAY86", FCXXCoord ( 0.858824, 0.858824, 0.858824)),
    std::pair<std::string, FCXXCoord  >("GRAY87", FCXXCoord ( 0.870588, 0.870588, 0.870588)),
    std::pair<std::string, FCXXCoord  >("GRAY88", FCXXCoord ( 0.878431, 0.878431, 0.878431)),
    std::pair<std::string, FCXXCoord  >("GRAY95", FCXXCoord ( 0.94902, 0.94902, 0.94902)),
    std::pair<std::string, FCXXCoord  >("GRAY96", FCXXCoord ( 0.960784, 0.960784, 0.960784)),
    std::pair<std::string, FCXXCoord  >("GRAY97", FCXXCoord ( 0.968627, 0.968627, 0.968627)),
    std::pair<std::string, FCXXCoord  >("DARK_BLUE", FCXXCoord ( 0.0, 0.0, 0.0,.545098)),
    std::pair<std::string, FCXXCoord  >("SGIGREY100", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("SGIDARKGRAY", FCXXCoord ( 0.333333, 0.333333, 0.333333)),
    std::pair<std::string, FCXXCoord  >("SNOW", FCXXCoord ( 1.0, 0.980392, 0.980392)),
    std::pair<std::string, FCXXCoord  >("GHOST_WHITE", FCXXCoord ( 0.972549, 0.972549, 1)),
    std::pair<std::string, FCXXCoord  >("WHITE_SMOKE", FCXXCoord ( 0.960784, 0.960784, 0.960784)),
    std::pair<std::string, FCXXCoord  >("MEDIUMSLATEBLUE", FCXXCoord ( 0.482353, 0.407843, 0.933333)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_BLUE", FCXXCoord ( 0.0, 0.0, 0.0,.803922)),
    std::pair<std::string, FCXXCoord  >("SPRING_GREEN", FCXXCoord ( 0.0, 1.0, 0.498039)),
    std::pair<std::string, FCXXCoord  >("LIGHT_YELLOW", FCXXCoord ( 1.0, 1.0, 0.0,.878431)),
    std::pair<std::string, FCXXCoord  >("LIGHT_GOLDENROD", FCXXCoord ( 0.933333, 0.866667, 0.509804)),
    std::pair<std::string, FCXXCoord  >("BLUEVIOLET", FCXXCoord ( 0.541176, 0.168627, 0.886275)),
    std::pair<std::string, FCXXCoord  >("SEASHELL4", FCXXCoord ( 0.545098, 0.52549, 0.509804)),
    std::pair<std::string, FCXXCoord  >("PEACHPUFF1", FCXXCoord ( 1.0, 0.854902, 0.72549)),
    std::pair<std::string, FCXXCoord  >("BLUE1", FCXXCoord ( 0.0, 0.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("STEELBLUE4", FCXXCoord ( 0.211765, 0.392157, 0.545098)),
    std::pair<std::string, FCXXCoord  >("LIGHTSKYBLUE4", FCXXCoord ( 0.376471, 0.482353, 0.545098)),
    std::pair<std::string, FCXXCoord  >("PALETURQUOISE3", FCXXCoord ( 0.588235, 0.803922, 0.803922)),
    std::pair<std::string, FCXXCoord  >("CYAN1", FCXXCoord ( 0.0, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("CYAN2", FCXXCoord ( 0.0, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("PALEGREEN1", FCXXCoord ( 0.603922, 1.0, 0.603922)),
    std::pair<std::string, FCXXCoord  >("LIGHTGOLDENROD1", FCXXCoord ( 1.0, 0.92549, 0.545098)),
    std::pair<std::string, FCXXCoord  >("ROSYBROWN3", FCXXCoord ( 0.803922, 0.607843, 0.607843)),
    std::pair<std::string, FCXXCoord  >("SIENNA3", FCXXCoord ( 0.803922, 0.407843, 0.223529)),
    std::pair<std::string, FCXXCoord  >("GRAY5", FCXXCoord ( 0.0509804, 0.0509804, 0.0509804)),
    std::pair<std::string, FCXXCoord  >("GREY40", FCXXCoord ( 0.4, 0.4, 0.4)),
    std::pair<std::string, FCXXCoord  >("GRAY82", FCXXCoord ( 0.819608, 0.819608, 0.819608)),
    std::pair<std::string, FCXXCoord  >("GRAY91", FCXXCoord ( 0.909804, 0.909804, 0.909804)),
    std::pair<std::string, FCXXCoord  >("DARKGRAY", FCXXCoord ( 0.662745, 0.662745, 0.662745)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_32", FCXXCoord ( 0.317647, 0.317647, 0.317647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_84", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("SGIGREY92", FCXXCoord ( 0.917647, 0.917647, 0.917647)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY100", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("SGISALMON", FCXXCoord ( 0.776471, 0.443137, 0.443137)),
    std::pair<std::string, FCXXCoord  >("SGI_VERY_LIGHT_GRAY", FCXXCoord ( 0.839216, 0.839216, 0.839216)),
    std::pair<std::string, FCXXCoord  >("BLANCHEDALMOND", FCXXCoord ( 1.0, 0.921569, 0.803922)),
    std::pair<std::string, FCXXCoord  >("CORNSILK", FCXXCoord ( 1.0, 0.972549, 0.862745)),
    std::pair<std::string, FCXXCoord  >("DARKSLATEGRAY", FCXXCoord ( 0.184314, 0.309804, 0.309804)),
    std::pair<std::string, FCXXCoord  >("LIGHTSEAGREEN", FCXXCoord ( 0.12549, 0.698039, 0.666667)),
    std::pair<std::string, FCXXCoord  >("PLUM", FCXXCoord ( 0.866667, 0.627451, 0.866667)),
    std::pair<std::string, FCXXCoord  >("LEMONCHIFFON3", FCXXCoord ( 0.803922, 0.788235, 0.647059)),
    std::pair<std::string, FCXXCoord  >("IVORY2", FCXXCoord ( 0.933333, 0.933333, 0.878431)),
    std::pair<std::string, FCXXCoord  >("BLUE3", FCXXCoord ( 0.0, 0.0, 0.0,.803922)),
    std::pair<std::string, FCXXCoord  >("CYAN4", FCXXCoord ( 0.0, 0.545098, 0.545098)),
    std::pair<std::string, FCXXCoord  >("ROSYBROWN1", FCXXCoord ( 1.0, 0.756863, 0.756863)),
    std::pair<std::string, FCXXCoord  >("SALMON2", FCXXCoord ( 0.933333, 0.509804, 0.384314)),
    std::pair<std::string, FCXXCoord  >("DARKORANGE2", FCXXCoord ( 0.933333, 0.462745, 0)),
    std::pair<std::string, FCXXCoord  >("PINK1", FCXXCoord ( 1.0, 0.709804, 0.772549)),
    std::pair<std::string, FCXXCoord  >("GREY2", FCXXCoord ( 0.0196078, 0.0196078, 0.0196078)),
    std::pair<std::string, FCXXCoord  >("GRAY7", FCXXCoord ( 0.0705882, 0.0705882, 0.0705882)),
    std::pair<std::string, FCXXCoord  >("GREY16", FCXXCoord ( 0.160784, 0.160784, 0.160784)),
    std::pair<std::string, FCXXCoord  >("GRAY17", FCXXCoord ( 0.168627, 0.168627, 0.168627)),
    std::pair<std::string, FCXXCoord  >("GRAY48", FCXXCoord ( 0.478431, 0.478431, 0.478431)),
    std::pair<std::string, FCXXCoord  >("GREY91", FCXXCoord ( 0.909804, 0.909804, 0.909804)),
    std::pair<std::string, FCXXCoord  >("GREY92", FCXXCoord ( 0.921569, 0.921569, 0.921569)),
    std::pair<std::string, FCXXCoord  >("GREY93", FCXXCoord ( 0.929412, 0.929412, 0.929412)),
    std::pair<std::string, FCXXCoord  >("SGIGREY20", FCXXCoord ( 0.2, 0.2, 0.2)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY32", FCXXCoord ( 0.317647, 0.317647, 0.317647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_52", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_60", FCXXCoord ( 0.6, 0.6, 0.6)),
    std::pair<std::string, FCXXCoord  >("SGIGREY72", FCXXCoord ( 0.717647, 0.717647, 0.717647)),
    std::pair<std::string, FCXXCoord  >("SGIOLIVEDRAB", FCXXCoord ( 0.556863, 0.556863, 0.219608)),
    std::pair<std::string, FCXXCoord  >("PAPAYA_WHIP", FCXXCoord ( 1.0, 0.937255, 0.835294)),
    std::pair<std::string, FCXXCoord  >("PAPAYAWHIP", FCXXCoord ( 1.0, 0.937255, 0.835294)),
    std::pair<std::string, FCXXCoord  >("AZURE", FCXXCoord ( 0.941176, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("DIMGRAY", FCXXCoord ( 0.411765, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("LIGHTSTEELBLUE", FCXXCoord ( 0.690196, 0.768627, 0.870588)),
    std::pair<std::string, FCXXCoord  >("AQUAMARINE", FCXXCoord ( 0.498039, 1.0, 0.831373)),
    std::pair<std::string, FCXXCoord  >("MEDIUMSPRINGGREEN", FCXXCoord ( 0.0, 0.980392, 0.603922)),
    std::pair<std::string, FCXXCoord  >("PALE_GOLDENROD", FCXXCoord ( 0.933333, 0.909804, 0.666667)),
    std::pair<std::string, FCXXCoord  >("SANDY_BROWN", FCXXCoord ( 0.956863, 0.643137, 0.376471)),
    std::pair<std::string, FCXXCoord  >("TOMATO", FCXXCoord ( 1.0, 0.388235, 0.278431)),
    std::pair<std::string, FCXXCoord  >("MISTYROSE3", FCXXCoord ( 0.803922, 0.717647, 0.709804)),
    std::pair<std::string, FCXXCoord  >("ROYALBLUE1", FCXXCoord ( 0.282353, 0.462745, 1)),
    std::pair<std::string, FCXXCoord  >("ROYALBLUE2", FCXXCoord ( 0.262745, 0.431373, 0.933333)),
    std::pair<std::string, FCXXCoord  >("SKYBLUE4", FCXXCoord ( 0.290196, 0.439216, 0.545098)),
    std::pair<std::string, FCXXCoord  >("LIGHTCYAN1", FCXXCoord ( 0.878431, 1.0, 1)),
    std::pair<std::string, FCXXCoord  >("CHARTREUSE3", FCXXCoord ( 0.4, 0.803922, 0)),
    std::pair<std::string, FCXXCoord  >("DARKOLIVEGREEN2", FCXXCoord ( 0.737255, 0.933333, 0.407843)),
    std::pair<std::string, FCXXCoord  >("HOTPINK2", FCXXCoord ( 0.933333, 0.415686, 0.654902)),
    std::pair<std::string, FCXXCoord  >("HOTPINK3", FCXXCoord ( 0.803922, 0.376471, 0.564706)),
    std::pair<std::string, FCXXCoord  >("HOTPINK4", FCXXCoord ( 0.545098, 0.227451, 0.384314)),
    std::pair<std::string, FCXXCoord  >("VIOLETRED4", FCXXCoord ( 0.545098, 0.133333, 0.321569)),
    std::pair<std::string, FCXXCoord  >("GREY0", FCXXCoord ( 0.0, 0.0, 0.0)),
    std::pair<std::string, FCXXCoord  >("GREY27", FCXXCoord ( 0.270588, 0.270588, 0.270588)),
    std::pair<std::string, FCXXCoord  >("GREY33", FCXXCoord ( 0.329412, 0.329412, 0.329412)),
    std::pair<std::string, FCXXCoord  >("GREY64", FCXXCoord ( 0.639216, 0.639216, 0.639216)),
    std::pair<std::string, FCXXCoord  >("GREY65", FCXXCoord ( 0.65098, 0.65098, 0.65098)),
    std::pair<std::string, FCXXCoord  >("GREY66", FCXXCoord ( 0.658824, 0.658824, 0.658824)),
    std::pair<std::string, FCXXCoord  >("GRAY68", FCXXCoord ( 0.678431, 0.678431, 0.678431)),
    std::pair<std::string, FCXXCoord  >("GRAY69", FCXXCoord ( 0.690196, 0.690196, 0.690196)),
    std::pair<std::string, FCXXCoord  >("GRAY76", FCXXCoord ( 0.760784, 0.760784, 0.760784)),
    std::pair<std::string, FCXXCoord  >("DARKGREY", FCXXCoord ( 0.662745, 0.662745, 0.662745)),
    std::pair<std::string, FCXXCoord  >("SGIGREY32", FCXXCoord ( 0.317647, 0.317647, 0.317647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_48", FCXXCoord ( 0.478431, 0.478431, 0.478431)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY52", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_100", FCXXCoord ( 1.0, 1.0, 1.0)),
    std::pair<std::string, FCXXCoord  >("SGI_VERY_DARK_GREY", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SEASHELL", FCXXCoord ( 1.0, 0.960784, 0.933333)),
    std::pair<std::string, FCXXCoord  >("DARK_SLATE_GREY", FCXXCoord ( 0.184314, 0.309804, 0.309804)),
    std::pair<std::string, FCXXCoord  >("DIM_GRAY", FCXXCoord ( 0.411765, 0.411765, 0.411765)),
    std::pair<std::string, FCXXCoord  >("LIGHT_GREY", FCXXCoord ( 0.827451, 0.827451, 0.827451)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_SLATE_BLUE", FCXXCoord ( 0.482353, 0.407843, 0.933333)),
    std::pair<std::string, FCXXCoord  >("LIGHTBLUE", FCXXCoord ( 0.678431, 0.847059, 0.901961)),
    std::pair<std::string, FCXXCoord  >("PALE_TURQUOISE", FCXXCoord ( 0.686275, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("PALETURQUOISE", FCXXCoord ( 0.686275, 0.933333, 0.933333)),
    std::pair<std::string, FCXXCoord  >("MEDIUM_SEA_GREEN", FCXXCoord ( 0.235294, 0.701961, 0.443137)),
    std::pair<std::string, FCXXCoord  >("BURLYWOOD", FCXXCoord ( 0.870588, 0.721569, 0.529412)),
    std::pair<std::string, FCXXCoord  >("SANDYBROWN", FCXXCoord ( 0.956863, 0.643137, 0.376471)),
    std::pair<std::string, FCXXCoord  >("IVORY4", FCXXCoord ( 0.545098, 0.545098, 0.513725)),
    std::pair<std::string, FCXXCoord  >("SEAGREEN3", FCXXCoord ( 0.262745, 0.803922, 0.501961)),
    std::pair<std::string, FCXXCoord  >("SEAGREEN4", FCXXCoord ( 0.180392, 0.545098, 0.341176)),
    std::pair<std::string, FCXXCoord  >("GREEN1", FCXXCoord ( 0.0, 1.0, 0)),
    std::pair<std::string, FCXXCoord  >("GREEN4", FCXXCoord ( 0.0, 0.545098, 0)),
    std::pair<std::string, FCXXCoord  >("CHARTREUSE1", FCXXCoord ( 0.498039, 1.0, 0)),
    std::pair<std::string, FCXXCoord  >("GOLD2", FCXXCoord ( 0.933333, 0.788235, 0)),
    std::pair<std::string, FCXXCoord  >("CORAL2", FCXXCoord ( 0.933333, 0.415686, 0.313725)),
    std::pair<std::string, FCXXCoord  >("ORANGERED1", FCXXCoord ( 1.0, 0.270588, 0)),
    std::pair<std::string, FCXXCoord  >("PINK4", FCXXCoord ( 0.545098, 0.388235, 0.423529)),
    std::pair<std::string, FCXXCoord  >("PLUM2", FCXXCoord ( 0.933333, 0.682353, 0.933333)),
    std::pair<std::string, FCXXCoord  >("GREY99", FCXXCoord ( 0.988235, 0.988235, 0.988235)),
    std::pair<std::string, FCXXCoord  >("DARK_GREY", FCXXCoord ( 0.662745, 0.662745, 0.662745)),
    std::pair<std::string, FCXXCoord  >("LIGHT_GREEN", FCXXCoord ( 0.564706, 0.933333, 0.564706)),
    std::pair<std::string, FCXXCoord  >("SGIGREY8", FCXXCoord ( 0.0784314, 0.0784314, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_52", FCXXCoord ( 0.517647, 0.517647, 0.517647)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_60", FCXXCoord ( 0.6, 0.6, 0.6)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_96", FCXXCoord ( 0.956863, 0.956863, 0.956863)),
    std::pair<std::string, FCXXCoord  >("SGI_CHARTREUSE", FCXXCoord ( 0.443137, 0.776471, 0.443137)),
    std::pair<std::string, FCXXCoord  >("SGILIGHTGREY", FCXXCoord ( 0.666667, 0.666667, 0.666667)),
    std::pair<std::string, FCXXCoord  >("SLATE_GRAY", FCXXCoord ( 0.439216, 0.501961, 0.564706)),
    std::pair<std::string, FCXXCoord  >("LIGHT_BLUE", FCXXCoord ( 0.678431, 0.847059, 0.901961)),
    std::pair<std::string, FCXXCoord  >("MEDIUMTURQUOISE", FCXXCoord ( 0.282353, 0.819608, 0.8)),
    std::pair<std::string, FCXXCoord  >("DARK_SEA_GREEN", FCXXCoord ( 0.560784, 0.737255, 0.560784)),
    std::pair<std::string, FCXXCoord  >("PALEVIOLETRED", FCXXCoord ( 0.858824, 0.439216, 0.576471)),
    std::pair<std::string, FCXXCoord  >("DARKORCHID", FCXXCoord ( 0.6, 0.196078, 0.8)),
    std::pair<std::string, FCXXCoord  >("BLUE_VIOLET", FCXXCoord ( 0.541176, 0.168627, 0.886275)),
    std::pair<std::string, FCXXCoord  >("MEDIUMPURPLE", FCXXCoord ( 0.576471, 0.439216, 0.858824)),
    std::pair<std::string, FCXXCoord  >("SEASHELL1", FCXXCoord ( 1.0, 0.960784, 0.933333)),
    std::pair<std::string, FCXXCoord  >("CORNSILK3", FCXXCoord ( 0.803922, 0.784314, 0.694118)),
    std::pair<std::string, FCXXCoord  >("DODGERBLUE1", FCXXCoord ( 0.117647, 0.564706, 1)),
    std::pair<std::string, FCXXCoord  >("DODGERBLUE2", FCXXCoord ( 0.109804, 0.52549, 0.933333)),
    std::pair<std::string, FCXXCoord  >("SLATEGRAY1", FCXXCoord ( 0.776471, 0.886275, 1)),
    std::pair<std::string, FCXXCoord  >("LIGHTSTEELBLUE3", FCXXCoord ( 0.635294, 0.709804, 0.803922)),
    std::pair<std::string, FCXXCoord  >("GREEN3", FCXXCoord ( 0.0, 0.803922, 0)),
    std::pair<std::string, FCXXCoord  >("ORANGERED4", FCXXCoord ( 0.545098, 0.145098, 0)),
    std::pair<std::string, FCXXCoord  >("MEDIUMORCHID1", FCXXCoord ( 0.878431, 0.4, 1)),
    std::pair<std::string, FCXXCoord  >("GRAY24", FCXXCoord ( 0.239216, 0.239216, 0.239216)),
    std::pair<std::string, FCXXCoord  >("GRAY28", FCXXCoord ( 0.278431, 0.278431, 0.278431)),
    std::pair<std::string, FCXXCoord  >("GRAY42", FCXXCoord ( 0.419608, 0.419608, 0.419608)),
    std::pair<std::string, FCXXCoord  >("GRAY46", FCXXCoord ( 0.458824, 0.458824, 0.458824)),
    std::pair<std::string, FCXXCoord  >("GREY59", FCXXCoord ( 0.588235, 0.588235, 0.588235)),
    std::pair<std::string, FCXXCoord  >("GREY98", FCXXCoord ( 0.980392, 0.980392, 0.980392)),
    std::pair<std::string, FCXXCoord  >("DARKMAGENTA", FCXXCoord ( 0.545098, 0.0, 0.545098)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_4", FCXXCoord ( 0.0392157, 0.0392157, 0.0392157)),
    std::pair<std::string, FCXXCoord  >("SGI_GREY_8", FCXXCoord ( 0.0784314, 0.0784314, 0.0784314)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY16", FCXXCoord ( 0.156863, 0.156863, 0.156863)),
    std::pair<std::string, FCXXCoord  >("SGIGREY68", FCXXCoord ( 0.678431, 0.678431, 0.678431)),
    std::pair<std::string, FCXXCoord  >("SGIGRAY72", FCXXCoord ( 0.717647, 0.717647, 0.717647)),
    std::pair<std::string, FCXXCoord  >("SGI_GRAY_92", FCXXCoord ( 0.917647, 0.917647, 0.917647))
};

std::map<std::string, FCXXCoord  > SolidColorRule::knownColors = std::map<std::string, FCXXCoord  > (SolidColorRule::nameColorPairs,
                   SolidColorRule::nameColorPairs +
                   (sizeof(SolidColorRule::nameColorPairs)/sizeof(std::pair<std::string, FCXXCoord  >)));

std::shared_ptr<SolidColorRule> SolidColorRule::colorRuleForSelectionStringAndName(std::string selectionString, std::string _name){
    auto selection = CompoundSelection::create(selectionString, selectionString+"_"+_name);
    return colorRuleForSelectionAndName(selection, _name);
}

std::shared_ptr<SolidColorRule> SolidColorRule::colorRuleForSelectionStringAndColor(std::string selectionString, FCXXCoord color){
    auto selection = CompoundSelection::create(selectionString, selectionString+"_"+"colorAsCoord");
    return colorRuleForSelectionAndColor(selection, color);
}

std::shared_ptr<SolidColorRule> SolidColorRule::colorRuleForSelectionAndName(std::shared_ptr<CompoundSelection> sel, std::string _name){
    std::transform(_name.begin(), _name.end(), _name.begin(), (int(*)(int)) std::toupper);
    if (knownColors.find( _name ) != knownColors.end()){
        FCXXCoord color = knownColors[_name];
        return colorRuleForSelectionAndColor(sel, color);
    } else {
        if (_name.length() == 7 || _name.length() == 9) {
            if (_name[0] == '#') {
                FCXXCoord col = SolidColorRule::colorHexToColor(_name);
                return colorRuleForSelectionAndColor(sel, col);
            }
        }
    }
    return 0;
}

std::shared_ptr<SolidColorRule> SolidColorRule::colorRuleForSelectionAndColor(std::shared_ptr<CompoundSelection> sel, FCXXCoord color)
{
    auto result = std::shared_ptr<SolidColorRule>(new SolidColorRule());
    result->setCompoundSelection(sel);
    result->setColor(color);
    return result;
}

std::shared_ptr<FCXXCoord> SolidColorRule::colorForName(std::string _name)
{
    std::shared_ptr<FCXXCoord> result = 0;
    std::transform(_name.begin(), _name.end(), _name.begin(), (int(*)(int)) std::toupper);
    if (knownColors.find( _name ) != knownColors.end()){
        result = std::make_shared<FCXXCoord>(knownColors[_name]);
    } else {
        if (_name.length() == 7) {
            if (_name[0] == '#') {
                result = std::make_shared<FCXXCoord> (colorHexToColor(_name));
            }
        }
    }
    return result;
}

// static 
FCXXCoord SolidColorRule::colorHexToColor(const std::string &_name) {

    // If it doesn't work out, return mid-grey
    FCXXCoord result(0.5, 0.5, 0.5);
    if (_name.length() == 7) {
        if (_name[0] == '#') {
            for (std::size_t i=0; i<3; i++) {
                std::stringstream ss;
                int icol;
                ss << std::hex << _name.substr(i*2+1,2);
                ss >> icol;
                result[i] = static_cast<float> (icol)/255.0;
            }
            result[3] = 1.0;
        }
    }
    else if (_name.length() == 9) {
        if (_name[0] == '#') {
            for (std::size_t i=0; i<4; i++) {
                std::stringstream ss;
                int icol;
                ss << std::hex << _name.substr(i*2+1,2);
                ss >> icol;
                result[i] = static_cast<float> (icol)/255.0;
            }
        }
    }
    //std::cout << "Colour " << result[0] << ' ' << result[1] << ' ' << result[2] << ' ' << result[3] << '\n';
    return result;
}

