*** Settings ***
Documentation       Check Huawei equipments in SNMP.

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s
Test Setup          Ctn Generic Suite Setup

*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=network::huawei::wlc::snmp::plugin


*** Test Cases ***
ap-status ${tc}
    [Tags]    network    snmp
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=ap-status
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=network/huawei/wlc/snmp/slim_huawei_wlc
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc     extra_options                                                                                                                                                                         expected_result    --
            ...      1      --verbose --filter-name='Anonymized 015'                                                                                                                                              OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 015' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0; checking access point 'Anonymized 015' status: normal
            ...      2      --filter-counters='^total$|^total-normal$'                                                                                                                                            OK: Access points total: 225, normal: 217 - All access points are ok | 'total'=225;;;0; 'total_normal'=217;;;0; 
            ...      3      --filter-name='Anonymized 015'                                                                                                                                                        OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 015' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0; 
            ...      4      --filter-address='' --filter-name='Anonymized 015'                                                                                                                                    OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 015' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      5      --filter-group="" --filter-name='Anonymized 075'                                                                                                                                      OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 075' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;  
            ...      6      --warning-status='\\\%{runstate} =~ /countryCodeMismatch|typeNotMatch/' --filter-name='Anonymized 030'                                                                                OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 030' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0; 
            ...      7      --critical-status='\\\%{runstate} =~ /fault|configFailed|commitFailed|verMismatch|nameConflicted|invalid/' --filter-name='Anonymized 010'                                             OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 010' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      8      --warning-total=0 --critical-total=100 --filter-name='Anonymized 010'                                                                                                                 WARNING: Access points total: 1 | 'total'=1;0:0;0:100;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      9      --warning-total-idle=1 --critical-total-idle=2 --filter-name='Anonymized 010'                                                                                                         OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 010' status: normal | 'total'=1;;;0; 'total_idle'=0;0:1;0:2;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      10     --warning-total-autofind=0 --critical-total-autofind=10 --filter-name='Anonymized 000'                                                                                                OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;0:0;0:10;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      11     --warning-total-typeNotMatch='10' --critical-total-typeNotMatch='0' --filter-name='Anonymized 000'                                                                                    OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;0:10;0:0;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0; 
            ...      12     --warning-total-fault=0 --critical-total-fault=0 --filter-name='Anonymized 001'                                                                                                       OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 001' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;0:0;0:0;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      13     --warning-total-config=0 --critical-total-config=0 --filter-name='Anonymized 000'                                                                                                     OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;0:0;0:0;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      14     --warning-total-config-failed=0 --critical-total-config-failed=0 --filter-name='Anonymized 000'                                                                                       OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;0:0;0:0;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      15     --warning-total-download=0 --critical-total-download=0 --filter-name='Anonymized 000'                                                                                                 OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;0:0;0:0;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      16     --warning-total-normal=0 --critical-total-normal=0 --filter-name='Anonymized 000'                                                                                                     CRITICAL: Access points normal: 1 | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;0:0;0:0;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      17     --warning-total-committing=0 --critical-total-committing=0 --filter-name='Anonymized 000'                                                                                             OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;0:0;0:0;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      18     --warning-total-commit-failed=0 --critical-total-commit-failed=0 --filter-name='Anonymized 000'                                                                                       OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;0:0;0:0;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      19     --warning-total-version-mismatch=0 --critical-total-version-mismatch=0 --filter-name='Anonymized 000'                                                                                 OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;0:0;0:0;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      20     --warning-total-name-conflicted=0 --critical-total-name-conflicted=0 --filter-name='Anonymized 000'                                                                                   OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;0:0;0:0;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;
            ...      21     --warning-total-invalid=0 --critical-total-invalid=0 --filter-name='Anonymized 000'                                                                                                   OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;0:0;0:0;0; 'total_country_code_mismatch'=0;;;0;
            ...      22     --warning-total-country-code-mismatch=0 --critical-total-country-code-mismatch=0 --filter-name='Anonymized 000'                                                                       OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 000' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;;;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;0:0;0:0;0;
            ...      23     --warning-total-standby=0 --critical-total-standby=0 --filter-name='Anonymized 010'                                                                                                   OK: Access points total: 1, idle: 0, autofind: 0, fault: 0, config: 0, config failed: 0, download: 0, normal: 1, committing: 0, commit failed: 0, standby: 0, version mismatch: 0, name conflicted: 0, invalid: 0, country code mismatch: 0 - access point 'Anonymized 010' status: normal | 'total'=1;;;0; 'total_idle'=0;;;0; 'total_autofind'=0;;;0; 'total_type_not_match'=0;;;0; 'total_fault'=0;;;0; 'total_config'=0;;;0; 'total_config_failed'=0;;;0; 'total_download'=0;;;0; 'total_normal'=1;;;0; 'total_committing'=0;;;0; 'total_commit_failed'=0;;;0; 'total_standby'=0;0:0;0:0;0; 'total_version_mismatch'=0;;;0; 'total_name_conflicted'=0;;;0; 'total_invalid'=0;;;0; 'total_country_code_mismatch'=0;;;0;