// Copyright (c) 1997 by Jim Lynch.
// Copyright (c) 2010-2012,2026 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this software; see the file COPYING.  If not, write to
//    the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//    Boston, MA 02110-1301, USA.

#ifndef Animal_h
#define Animal_h

#include "Record.h"
#include <sstream>

#include "str-conversions.h"

class Animal : public Record
{
    private:
        std::string *animal;

        void Default(void)
        {
            animal = new std::string;
        }

        void Set(const char *anAnimal)
        {
            animal = new std::string(anAnimal);
        }

        void Copy(const Animal &orig)
        {
            if(orig.animal)
            {
                animal = new std::string(*orig.animal);
            }
            else
            {
                animal = 0;
            }
        }

    protected:

        virtual void Destroy(void)
        {
            if(animal)
                delete animal;

            animal = 0;
        }

        virtual void SetNull(void)
        {
            animal = new std::string;
        }

        virtual void SetFromDataString(const char *theDataString)
        {
            const char *data = theDataString;

            if(data[0] == 'a')
            {
                std::istringstream it(data + 2);
                std::ostringstream theAnimal;

                // grab the animal text
                char nextCh = it.get();

                while(nextCh != '|')
                {
                    theAnimal << nextCh;

                    nextCh = it.get();
                }

                animal = new std::string(MakeCStringCopy(theAnimal));
            }
            else
                SetNull();
        }

    public:
        Animal()
        {
            Default();
        }

        Animal(const char *anAnimal)
        {
            Set(anAnimal);
        }

        Animal(std::string &anAnimal)
        {
            Set(anAnimal.c_str());
        }

        Animal(const Animal &orig)
        {
            Copy(orig);
        }

        Animal &operator=(const Animal &orig)
        {
            Destroy();
            Copy(orig);

            return *this;
        }

        virtual ~Animal()
        {
            Destroy();
        }

        Animal(sqlite3 *handle, const char *animalKey)
        {
            Default();

            Read(handle, animalKey);
        }

        Animal(sqlite3 *handle, const std::string &animalKey)
        {
            Default();

            Read(handle, animalKey);
        }

        virtual const char *FormNewDataCString() const
        {
            std::string temp = "a|";

            if(animal)
                temp += (*animal);

            temp += "|";

            return MakeCStringCopy(temp);
        }

        virtual void Print(std::ostream &out) const
        {
            out << (animal ? (*animal) : std::string());
        }
};

#endif
