// RUN: mlir-opt -convert-spirv-to-llvm %s | FileCheck %s

// NOTE: Assertions have been autogenerated by utils/generate-test-checks.py

// CHECK-LABEL:   llvm.func spir_funccc @_Z33__spirv_GroupNonUniformLogicalXoriib(i32, i32, i1) -> i1 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z32__spirv_GroupNonUniformLogicalOriib(i32, i32, i1) -> i1 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z33__spirv_GroupNonUniformLogicalAndiib(i32, i32, i1) -> i1 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z33__spirv_GroupNonUniformBitwiseXoriij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z32__spirv_GroupNonUniformBitwiseOriij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z33__spirv_GroupNonUniformBitwiseAndiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformSMaxiijj(i32, i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformFMaxiif(i32, i32, f32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformUMaxiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformSMaxiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformFMiniifj(i32, i32, f32, i32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformFMiniif(i32, i32, f32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformUMiniij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformSMiniij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformFMuliif(i32, i32, f32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformIMuliijj(i32, i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformFAddiifj(i32, i32, f32, i32) -> f32 attributes {convergent, no_unwind, will_return}
// CHECK:         llvm.func spir_funccc @_Z27__spirv_GroupNonUniformIAddiij(i32, i32, i32) -> i32 attributes {convergent, no_unwind, will_return}

// CHECK-LABEL:   llvm.func @non_uniform_iadd(
// CHECK-SAME:                                %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformIAddiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_iadd(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformIAdd <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_fadd(
// CHECK-SAME:                                %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(16 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_4:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformFAddiifj(%[[VAL_2]], %[[VAL_3]], %[[VAL_0]], %[[VAL_1]]) {convergent, no_unwind, will_return} : (i32, i32, f32, i32) -> f32
// CHECK:           llvm.return %[[VAL_4]] : f32
// CHECK:         }
spirv.func @non_uniform_fadd(%arg0: f32) -> f32 "None" {
  %0 = spirv.Constant 16 : i32
  %1 = spirv.GroupNonUniformFAdd <Subgroup> <ClusteredReduce> %arg0 cluster_size(%0) : f32, i32 -> f32
  spirv.ReturnValue %1 : f32
}

// CHECK-LABEL:   llvm.func @non_uniform_imul(
// CHECK-SAME:                                %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(16 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_4:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformIMuliijj(%[[VAL_2]], %[[VAL_3]], %[[VAL_0]], %[[VAL_1]]) {convergent, no_unwind, will_return} : (i32, i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_4]] : i32
// CHECK:         }
spirv.func @non_uniform_imul(%arg0: i32) -> i32 "None" {
  %0 = spirv.Constant 16 : i32
  %1 = spirv.GroupNonUniformIMul <Subgroup> <ClusteredReduce> %arg0 cluster_size(%0) : i32, i32 -> i32
  spirv.ReturnValue %1 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_fmul(
// CHECK-SAME:                                %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformFMuliif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @non_uniform_fmul(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupNonUniformFMul <Subgroup> <Reduce> %arg0 : f32 -> f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @non_uniform_smin(
// CHECK-SAME:                                %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformSMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_smin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformSMin <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_umin(
// CHECK-SAME:                                %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformUMiniij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_umin(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformUMin <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_fmin(
// CHECK-SAME:                                %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformFMiniif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @non_uniform_fmin(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupNonUniformFMin <Subgroup> <Reduce> %arg0 : f32 -> f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @non_uniform_fmin_cluster(
// CHECK-SAME:                                        %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(16 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_4:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformFMiniifj(%[[VAL_2]], %[[VAL_3]], %[[VAL_0]], %[[VAL_1]]) {convergent, no_unwind, will_return} : (i32, i32, f32, i32) -> f32
// CHECK:           llvm.return %[[VAL_4]] : f32
// CHECK:         }
spirv.func @non_uniform_fmin_cluster(%arg0: f32) -> f32 "None" {
  %0 = spirv.Constant 16 : i32
  %1 = spirv.GroupNonUniformFMin <Subgroup> <ClusteredReduce> %arg0 cluster_size(%0) : f32, i32 -> f32
  spirv.ReturnValue %1 : f32
}

// CHECK-LABEL:   llvm.func @non_uniform_smax(
// CHECK-SAME:                                %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformSMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_smax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformSMax <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_umax(
// CHECK-SAME:                                %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformUMaxiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_umax(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformUMax <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_fmax(
// CHECK-SAME:                                %[[VAL_0:.*]]: f32) -> f32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformFMaxiif(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, f32) -> f32
// CHECK:           llvm.return %[[VAL_3]] : f32
// CHECK:         }
spirv.func @non_uniform_fmax(%arg0: f32) -> f32 "None" {
  %0 = spirv.GroupNonUniformFMax <Subgroup> <Reduce> %arg0 : f32 -> f32
  spirv.ReturnValue %0 : f32
}

// CHECK-LABEL:   llvm.func @non_uniform_smax_cluster(
// CHECK-SAME:                                        %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(16 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_4:.*]] = llvm.call spir_funccc @_Z27__spirv_GroupNonUniformSMaxiijj(%[[VAL_2]], %[[VAL_3]], %[[VAL_0]], %[[VAL_1]]) {convergent, no_unwind, will_return} : (i32, i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_4]] : i32
// CHECK:         }
spirv.func @non_uniform_smax_cluster(%arg0: i32) -> i32 "None" {
  %0 = spirv.Constant 16 : i32
  %1 = spirv.GroupNonUniformSMax <Subgroup> <ClusteredReduce> %arg0 cluster_size(%0) : i32, i32 -> i32
  spirv.ReturnValue %1 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_bitwise_and(
// CHECK-SAME:                                       %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z33__spirv_GroupNonUniformBitwiseAndiij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_bitwise_and(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformBitwiseAnd <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_bitwise_or(
// CHECK-SAME:                                      %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z32__spirv_GroupNonUniformBitwiseOriij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_bitwise_or(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformBitwiseOr <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_bitwise_xor(
// CHECK-SAME:                                       %[[VAL_0:.*]]: i32) -> i32 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z33__spirv_GroupNonUniformBitwiseXoriij(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i32) -> i32
// CHECK:           llvm.return %[[VAL_3]] : i32
// CHECK:         }
spirv.func @non_uniform_bitwise_xor(%arg0: i32) -> i32 "None" {
  %0 = spirv.GroupNonUniformBitwiseXor <Subgroup> <Reduce> %arg0 : i32 -> i32
  spirv.ReturnValue %0 : i32
}

// CHECK-LABEL:   llvm.func @non_uniform_logical_and(
// CHECK-SAME:                                       %[[VAL_0:.*]]: i1) -> i1 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z33__spirv_GroupNonUniformLogicalAndiib(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i1) -> i1
// CHECK:           llvm.return %[[VAL_3]] : i1
// CHECK:         }
spirv.func @non_uniform_logical_and(%arg0: i1) -> i1 "None" {
  %0 = spirv.GroupNonUniformLogicalAnd <Subgroup> <Reduce> %arg0 : i1 -> i1
  spirv.ReturnValue %0 : i1
}

// CHECK-LABEL:   llvm.func @non_uniform_logical_or(
// CHECK-SAME:                                      %[[VAL_0:.*]]: i1) -> i1 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z32__spirv_GroupNonUniformLogicalOriib(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i1) -> i1
// CHECK:           llvm.return %[[VAL_3]] : i1
// CHECK:         }
spirv.func @non_uniform_logical_or(%arg0: i1) -> i1 "None" {
  %0 = spirv.GroupNonUniformLogicalOr <Subgroup> <Reduce> %arg0 : i1 -> i1
  spirv.ReturnValue %0 : i1
}

// CHECK-LABEL:   llvm.func @non_uniform_logical_xor(
// CHECK-SAME:                                       %[[VAL_0:.*]]: i1) -> i1 {
// CHECK:           %[[VAL_1:.*]] = llvm.mlir.constant(3 : i32) : i32
// CHECK:           %[[VAL_2:.*]] = llvm.mlir.constant(0 : i32) : i32
// CHECK:           %[[VAL_3:.*]] = llvm.call spir_funccc @_Z33__spirv_GroupNonUniformLogicalXoriib(%[[VAL_1]], %[[VAL_2]], %[[VAL_0]]) {convergent, no_unwind, will_return} : (i32, i32, i1) -> i1
// CHECK:           llvm.return %[[VAL_3]] : i1
// CHECK:         }
spirv.func @non_uniform_logical_xor(%arg0: i1) -> i1 "None" {
  %0 = spirv.GroupNonUniformLogicalXor <Subgroup> <Reduce> %arg0 : i1 -> i1
  spirv.ReturnValue %0 : i1
}
